/*
 * Decompiled with CFR 0.152.
 */
package com.github.fastshape;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.github.fastshape.Helper;
import com.github.fastshape.MyButton;
import com.github.fastshape.inter.ViewHelperInter;

public class BaseViewHelper
extends Helper {
    private ViewHelperInter viewHelperInter;
    public static final int shapeType_rectangle = 0;
    public static final int shapeType_oval = 1;
    public static final int shapeType_line = 2;
    public static final int shapeType_ring = 3;
    protected Integer shapeType = 0;
    protected boolean useLevel;
    protected boolean isPartBorder;
    protected boolean allLine;
    protected boolean leftLine;
    protected boolean topLine;
    protected boolean rightLine;
    protected boolean bottomLine;
    protected float borderWidth;
    protected int solidColor;
    protected int pressColor;
    protected int borderColor;
    protected float borderDashWidth;
    protected float borderDashGap;
    protected float radius;
    protected float topLeftRadius;
    protected float topRightRadius;
    protected float bottomLeftRadius;
    protected float bottomRightRadius;
    protected int[] partBorderWidth;
    protected Drawable drawable_normal;
    protected Drawable drawable_press;
    protected Integer angle;
    protected float centerX;
    protected float centerY;
    protected int startColor;
    protected int centerColor;
    protected int endColor;
    protected float gradientRadius;
    public static final int gradientType_linear = 0;
    public static final int gradientType_radial = 1;
    public static final int gradientType_sweep = 2;
    protected Integer gradientType = 0;

    public BaseViewHelper() {
        this(null);
    }

    public BaseViewHelper(ViewHelperInter inter) {
        this.viewHelperInter = inter;
    }

    public void complete() {
        if (this.viewHelperInter != null) {
            this.viewHelperInter.onComplete();
        }
    }

    public BaseViewHelper setShapeType(Integer shapeType) {
        this.shapeType = shapeType;
        return this;
    }

    public BaseViewHelper setUseLevel(boolean useLevel) {
        this.useLevel = useLevel;
        return this;
    }

    public BaseViewHelper setAllLine(boolean allLine) {
        this.allLine = allLine;
        return this;
    }

    public BaseViewHelper setLeftLine(boolean leftLine) {
        this.leftLine = leftLine;
        return this;
    }

    public BaseViewHelper setTopLine(boolean topLine) {
        this.topLine = topLine;
        return this;
    }

    public BaseViewHelper setRightLine(boolean rightLine) {
        this.rightLine = rightLine;
        return this;
    }

    public BaseViewHelper setBottomLine(boolean bottomLine) {
        this.bottomLine = bottomLine;
        return this;
    }

    public BaseViewHelper setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public BaseViewHelper setSolidColor(int solidColor) {
        this.solidColor = solidColor;
        return this;
    }

    public BaseViewHelper setPressColor(int pressColor) {
        this.pressColor = pressColor;
        return this;
    }

    public BaseViewHelper setBorderColor(int borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public BaseViewHelper setBorderDashWidth(float borderDashWidth) {
        this.borderDashWidth = borderDashWidth;
        return this;
    }

    public BaseViewHelper setBorderDashGap(float borderDashGap) {
        this.borderDashGap = borderDashGap;
        return this;
    }

    public BaseViewHelper setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public BaseViewHelper setTopLeftRadius(float topLeftRadius) {
        this.topLeftRadius = topLeftRadius;
        return this;
    }

    public BaseViewHelper setTopRightRadius(float topRightRadius) {
        this.topRightRadius = topRightRadius;
        return this;
    }

    public BaseViewHelper setBottomLeftRadius(float bottomLeftRadius) {
        this.bottomLeftRadius = bottomLeftRadius;
        return this;
    }

    public BaseViewHelper setBottomRightRadius(float bottomRightRadius) {
        this.bottomRightRadius = bottomRightRadius;
        return this;
    }

    public BaseViewHelper setDrawable_normal(Drawable drawable_normal) {
        this.drawable_normal = drawable_normal;
        return this;
    }

    public BaseViewHelper setDrawable_press(Drawable drawable_press) {
        this.drawable_press = drawable_press;
        return this;
    }

    public BaseViewHelper setAngle(Integer angle) {
        this.angle = angle;
        return this;
    }

    public BaseViewHelper setCenterX(float centerX) {
        this.centerX = centerX;
        return this;
    }

    public BaseViewHelper setCenterY(float centerY) {
        this.centerY = centerY;
        return this;
    }

    public BaseViewHelper setStartColor(int startColor) {
        this.startColor = startColor;
        return this;
    }

    public BaseViewHelper setCenterColor(int centerColor) {
        this.centerColor = centerColor;
        return this;
    }

    public BaseViewHelper setEndColor(int endColor) {
        this.endColor = endColor;
        return this;
    }

    public BaseViewHelper setGradientRadius(float gradientRadius) {
        this.gradientRadius = gradientRadius;
        return this;
    }

    public BaseViewHelper setGradientType(Integer gradientType) {
        this.gradientType = gradientType;
        return this;
    }

    public BaseViewHelper clearAttribute() {
        this.drawable_normal = null;
        this.drawable_press = null;
        this.pressColor = this.getTransparentColor();
        this.allLine = false;
        this.leftLine = false;
        this.topLine = false;
        this.rightLine = false;
        this.bottomLine = false;
        this.shapeType = 0;
        this.borderWidth = 0.0f;
        this.borderColor = this.getTransparentColor();
        this.borderDashWidth = 0.0f;
        this.borderDashGap = 0.0f;
        this.solidColor = this.getTransparentColor();
        this.radius = 0.0f;
        this.topLeftRadius = 0.0f;
        this.topRightRadius = 0.0f;
        this.bottomLeftRadius = 0.0f;
        this.bottomRightRadius = 0.0f;
        this.gradientType = -1;
        this.angle = 0;
        this.centerX = 0.5f;
        this.centerY = 0.5f;
        this.startColor = 0;
        this.centerColor = 0;
        this.endColor = 0;
        this.gradientRadius = 40.0f;
        return this;
    }

    public Integer getShapeType() {
        return this.shapeType;
    }

    public boolean isUseLevel() {
        return this.useLevel;
    }

    public boolean isAllLine() {
        return this.allLine;
    }

    public boolean isLeftLine() {
        return this.leftLine;
    }

    public boolean isTopLine() {
        return this.topLine;
    }

    public boolean isRightLine() {
        return this.rightLine;
    }

    public boolean isBottomLine() {
        return this.bottomLine;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public int getSolidColor() {
        return this.solidColor;
    }

    public int getPressColor() {
        return this.pressColor;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public float getBorderDashWidth() {
        return this.borderDashWidth;
    }

    public float getBorderDashGap() {
        return this.borderDashGap;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public float getTopRightRadius() {
        return this.topRightRadius;
    }

    public float getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public float getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public Drawable getDrawable_normal() {
        return this.drawable_normal;
    }

    public Drawable getDrawable_press() {
        return this.drawable_press;
    }

    public Integer getAngle() {
        return this.angle;
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public int getStartColor() {
        return this.startColor;
    }

    public int getCenterColor() {
        return this.centerColor;
    }

    public int getEndColor() {
        return this.endColor;
    }

    public float getGradientRadius() {
        return this.gradientRadius;
    }

    public Integer getGradientType() {
        return this.gradientType;
    }

    public GradientDrawable.Orientation getViewOrientation(int angle) {
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
        switch (angle) {
            case 0: {
                orientation = GradientDrawable.Orientation.LEFT_RIGHT;
                break;
            }
            case 45: {
                orientation = GradientDrawable.Orientation.BL_TR;
                break;
            }
            case 90: {
                orientation = GradientDrawable.Orientation.BOTTOM_TOP;
                break;
            }
            case 135: {
                orientation = GradientDrawable.Orientation.BR_TL;
                break;
            }
            case 180: {
                orientation = GradientDrawable.Orientation.RIGHT_LEFT;
                break;
            }
            case 225: {
                orientation = GradientDrawable.Orientation.TR_BL;
                break;
            }
            case 270: {
                orientation = GradientDrawable.Orientation.TOP_BOTTOM;
                break;
            }
            case 315: {
                orientation = GradientDrawable.Orientation.TL_BR;
            }
        }
        return orientation;
    }

    public GradientDrawable getNoPartBorderNoPressColorGradientDrawable(boolean isSetGradientType) {
        GradientDrawable gradientDrawableNormal = new GradientDrawable();
        gradientDrawableNormal.setShape(this.shapeType.intValue());
        if (this.allLine) {
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
            if (this.borderWidth <= 0.0f) {
                this.borderWidth = 1.0f;
            }
        }
        gradientDrawableNormal.setStroke((int)this.borderWidth, this.borderColor, this.borderDashWidth, this.borderDashGap);
        gradientDrawableNormal.setColor(this.solidColor);
        if (this.radius > 0.0f) {
            gradientDrawableNormal.setCornerRadius(this.radius);
        } else {
            float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
            gradientDrawableNormal.setCornerRadii(fourRadius);
        }
        if (isSetGradientType) {
            this.setGradientType(gradientDrawableNormal);
        }
        return gradientDrawableNormal;
    }

    private void setGradientType(GradientDrawable gradientDrawableNormal) {
        if (this.gradientType != -1) {
            gradientDrawableNormal.setGradientCenter(this.centerX, this.centerY);
            if (Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setOrientation(this.getViewOrientation(this.angle));
            }
            if (this.centerColor != 0) {
                if (Build.VERSION.SDK_INT >= 16) {
                    gradientDrawableNormal.setColors(new int[]{this.startColor, this.centerColor, this.endColor});
                }
            } else if ((this.startColor != 0 || this.endColor != 0) && Build.VERSION.SDK_INT >= 16) {
                gradientDrawableNormal.setColors(new int[]{this.startColor, this.endColor});
            }
            if (this.gradientType == 1) {
                gradientDrawableNormal.setGradientRadius(this.gradientRadius);
                gradientDrawableNormal.setUseLevel(false);
            }
            gradientDrawableNormal.setGradientType(this.gradientType.intValue());
        }
    }

    public GradientDrawable getHasPartBorderNoPressColorGradientDrawable() {
        GradientDrawable layerDrawable = new GradientDrawable();
        layerDrawable.setShape(this.shapeType.intValue());
        layerDrawable.setStroke((int)this.borderWidth, this.borderColor, this.borderDashWidth, this.borderDashGap);
        layerDrawable.setColor(this.solidColor);
        if (this.radius > 0.0f) {
            layerDrawable.setCornerRadius(this.radius);
        } else {
            float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
            layerDrawable.setCornerRadii(fourRadius);
        }
        return layerDrawable;
    }

    public GradientDrawable getHasPartBorderNoPressColorGradientDrawableNormal() {
        GradientDrawable layerGradientDrawableNormal = new GradientDrawable();
        layerGradientDrawableNormal.setShape(this.shapeType.intValue());
        if (this.solidColor == this.getTransparentColor()) {
            layerGradientDrawableNormal.setColor(Color.parseColor((String)"#ffffffff"));
        } else {
            layerGradientDrawableNormal.setColor(this.solidColor);
        }
        if (this.radius > 0.0f) {
            layerGradientDrawableNormal.setCornerRadius(this.radius);
        } else {
            float[] fourRadius = new float[]{this.topLeftRadius, this.topLeftRadius, this.topRightRadius, this.topRightRadius, this.bottomRightRadius, this.bottomRightRadius, this.bottomLeftRadius, this.bottomLeftRadius};
            layerGradientDrawableNormal.setCornerRadii(fourRadius);
        }
        return layerGradientDrawableNormal;
    }

    public LayerDrawable getHasPartBorderNoPressColorLayerDrawableNormal() {
        GradientDrawable layerDrawable = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable layerGradientDrawableNormal = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        Drawable[] layers = new Drawable[]{layerDrawable, layerGradientDrawableNormal};
        LayerDrawable layerDrawableNormal = new LayerDrawable(layers);
        layerDrawableNormal.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        return layerDrawableNormal;
    }

    protected void viewComplete(View myView) {
        if (this.drawable_normal != null) {
            StateListDrawable stateListDrawableForLayer = new StateListDrawable();
            stateListDrawableForLayer.addState(new int[]{-16842919}, this.drawable_normal);
            stateListDrawableForLayer.addState(new int[]{16842919}, this.drawable_press);
            stateListDrawableForLayer.addState(new int[0], this.drawable_normal);
            if (Build.VERSION.SDK_INT >= 16) {
                myView.setBackground((Drawable)stateListDrawableForLayer);
            } else {
                myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
            }
            return;
        }
        if (this.allLine || !this.leftLine && !this.topLine && !this.rightLine && !this.bottomLine) {
            this.isPartBorder = false;
        }
        if (!this.allLine && (this.leftLine || this.topLine || this.rightLine || this.bottomLine)) {
            this.isPartBorder = true;
        }
        if (this.shapeType == 2 && myView.getLayerType() == 0) {
            myView.setLayerType(1, null);
        }
        if (!this.isPartBorder) {
            if (this.pressColor == this.getTransparentColor()) {
                this.noPartBorderNoPressColor(myView);
            } else {
                this.noPartBorderHasPressColor(myView);
            }
        } else if (this.pressColor == this.getTransparentColor()) {
            this.hasPartBorderNoPressColor(myView);
        } else {
            this.hasPartBorderHasPressColor(myView);
        }
        if (myView instanceof MyButton) {
            this.setCompoundDrawables((Button)myView);
        } else {
            this.setCompoundDrawables(myView);
        }
    }

    private void setCompoundDrawables(Button myView) {
        int height;
        int width;
        Drawable drawable0 = myView.getCompoundDrawables()[0];
        Drawable drawable1 = myView.getCompoundDrawables()[1];
        Drawable drawable2 = myView.getCompoundDrawables()[2];
        Drawable drawable3 = myView.getCompoundDrawables()[3];
        if (drawable0 != null) {
            width = drawable0.getIntrinsicWidth();
            height = drawable0.getIntrinsicHeight();
            drawable0.setBounds(0, 0, this.getLeftWH(width, height)[0], this.getLeftWH(width, height)[1]);
        }
        if (drawable1 != null) {
            width = drawable1.getIntrinsicWidth();
            height = drawable1.getIntrinsicHeight();
            drawable1.setBounds(0, 0, this.getTopWH(width, height)[0], this.getTopWH(width, height)[1]);
        }
        if (drawable2 != null) {
            width = drawable2.getIntrinsicWidth();
            height = drawable2.getIntrinsicHeight();
            drawable2.setBounds(0, 0, this.getRightWH(width, height)[0], this.getRightWH(width, height)[1]);
        }
        if (drawable3 != null) {
            width = drawable3.getIntrinsicWidth();
            height = drawable3.getIntrinsicHeight();
            drawable3.setBounds(0, 0, this.getBottomWH(width, height)[0], this.getBottomWH(width, height)[1]);
        }
        myView.setCompoundDrawables(drawable0, drawable1, drawable2, drawable3);
    }

    private void setCompoundDrawables(View view) {
        if (view instanceof TextView) {
            int height;
            int width;
            TextView myView = (TextView)view;
            Drawable drawable0 = myView.getCompoundDrawables()[0];
            Drawable drawable1 = myView.getCompoundDrawables()[1];
            Drawable drawable2 = myView.getCompoundDrawables()[2];
            Drawable drawable3 = myView.getCompoundDrawables()[3];
            if (drawable0 != null) {
                width = drawable0.getIntrinsicWidth();
                height = drawable0.getIntrinsicHeight();
                drawable0.setBounds(0, 0, this.getLeftWH(width, height)[0], this.getLeftWH(width, height)[1]);
            }
            if (drawable1 != null) {
                width = drawable1.getIntrinsicWidth();
                height = drawable1.getIntrinsicHeight();
                drawable1.setBounds(0, 0, this.getTopWH(width, height)[0], this.getTopWH(width, height)[1]);
            }
            if (drawable2 != null) {
                width = drawable2.getIntrinsicWidth();
                height = drawable2.getIntrinsicHeight();
                drawable2.setBounds(0, 0, this.getRightWH(width, height)[0], this.getRightWH(width, height)[1]);
            }
            if (drawable3 != null) {
                width = drawable3.getIntrinsicWidth();
                height = drawable3.getIntrinsicHeight();
                drawable3.setBounds(0, 0, this.getBottomWH(width, height)[0], this.getBottomWH(width, height)[1]);
            }
            myView.setCompoundDrawables(drawable0, drawable1, drawable2, drawable3);
        }
    }

    private void noPartBorderNoPressColor(View myView) {
        GradientDrawable gradientDrawableNormal = this.getNoPartBorderNoPressColorGradientDrawable(true);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)gradientDrawableNormal);
        } else {
            myView.setBackgroundDrawable((Drawable)gradientDrawableNormal);
        }
    }

    private void noPartBorderHasPressColor(View myView) {
        GradientDrawable gradientDrawableNormal = this.getNoPartBorderNoPressColorGradientDrawable(false);
        GradientDrawable gradientDrawablePress = this.getNoPartBorderNoPressColorGradientDrawable(false);
        gradientDrawablePress.setColor(this.pressColor);
        StateListDrawable stateListDrawableForShape = new StateListDrawable();
        stateListDrawableForShape.addState(new int[]{-16842919}, (Drawable)gradientDrawableNormal);
        stateListDrawableForShape.addState(new int[]{16842919}, (Drawable)gradientDrawablePress);
        stateListDrawableForShape.addState(new int[0], (Drawable)gradientDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForShape);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForShape);
        }
    }

    private void hasPartBorderNoPressColor(View myView) {
        this.setBorderWidthForPartBorder();
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)this.getHasPartBorderNoPressColorLayerDrawableNormal());
        } else {
            myView.setBackgroundDrawable((Drawable)this.getHasPartBorderNoPressColorLayerDrawableNormal());
        }
    }

    private void hasPartBorderHasPressColor(View myView) {
        this.setBorderWidthForPartBorder();
        GradientDrawable gradientDrawable = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable gradientDrawableNormal = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        GradientDrawable gradientDrawablePress = this.getHasPartBorderNoPressColorGradientDrawable();
        GradientDrawable gradientDrawableNormalPress = this.getHasPartBorderNoPressColorGradientDrawableNormal();
        gradientDrawableNormalPress.setColor(this.pressColor);
        LayerDrawable layerDrawableNormal = new LayerDrawable(new Drawable[]{gradientDrawable, gradientDrawableNormal});
        layerDrawableNormal.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        LayerDrawable layerDrawablePress = new LayerDrawable(new Drawable[]{gradientDrawablePress, gradientDrawableNormalPress});
        layerDrawablePress.setLayerInset(1, this.partBorderWidth[0], this.partBorderWidth[1], this.partBorderWidth[2], this.partBorderWidth[3]);
        StateListDrawable stateListDrawableForLayer = new StateListDrawable();
        stateListDrawableForLayer.addState(new int[]{-16842919}, (Drawable)layerDrawableNormal);
        stateListDrawableForLayer.addState(new int[]{16842919}, (Drawable)layerDrawablePress);
        stateListDrawableForLayer.addState(new int[0], (Drawable)layerDrawableNormal);
        if (Build.VERSION.SDK_INT >= 16) {
            myView.setBackground((Drawable)stateListDrawableForLayer);
        } else {
            myView.setBackgroundDrawable((Drawable)stateListDrawableForLayer);
        }
    }

    protected int getDefBorderColor() {
        return Color.parseColor((String)"#E2E2E2");
    }

    protected int getDefColor() {
        return Color.parseColor((String)"#00000000");
    }

    protected int getTransparentColor() {
        return Color.parseColor((String)"#00000000");
    }

    protected void setBorderWidthForPartBorder() {
        this.partBorderWidth = new int[]{0, 0, 0, 0};
        if (this.leftLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[0] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.topLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[1] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.rightLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[2] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
        if (this.bottomLine) {
            if (this.borderWidth == 0.0f) {
                this.borderWidth = 1.0f;
            }
            this.partBorderWidth[3] = (int)this.borderWidth;
            if (this.borderColor == this.getTransparentColor()) {
                this.borderColor = this.getDefBorderColor();
            }
        }
    }
}

