/*
 * Decompiled with CFR 0.152.
 */
package me.toptas.fancyshowcase.internal;

import android.graphics.Rect;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import me.toptas.fancyshowcase.FocusShape;
import me.toptas.fancyshowcase.R;
import me.toptas.fancyshowcase.internal.AutoTextPosition;
import me.toptas.fancyshowcase.internal.CircleCenter;
import me.toptas.fancyshowcase.internal.DeviceParams;
import me.toptas.fancyshowcase.internal.IFocusedView;
import me.toptas.fancyshowcase.internal.Presenter$WhenMappings;
import me.toptas.fancyshowcase.internal.Properties;
import me.toptas.fancyshowcase.internal.SharedPref;
import me.toptas.fancyshowcase.listener.DismissListener;
import me.toptas.fancyshowcase.listener.OnQueueListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u000206J\u001e\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u0002082\u0006\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020?J\u0016\u0010E\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\u0016\u0010F\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\u0016\u0010G\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J\u0016\u0010H\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:J \u0010I\u001a\u0002062\u0006\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\n2\u0006\u0010L\u001a\u00020\nH\u0002J\u0006\u0010M\u001a\u000206J(\u0010N\u001a\u0002062\u0006\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\n2\u0006\u0010O\u001a\u00020\n2\u0006\u0010P\u001a\u00020\nH\u0002J\u0014\u0010Q\u001a\u0002062\f\u0010R\u001a\b\u0012\u0004\u0012\u0002060SJ\u0010\u0010T\u001a\u0002062\b\u0010U\u001a\u0004\u0018\u00010VR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u000eR\u001a\u0010\u001b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\f\"\u0004\b\u001d\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010\u000eR\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010'\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010\u000eR\u001a\u0010*\u001a\u00020+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\f\"\u0004\b2\u0010\u000e\u00a8\u0006W"}, d2={"Lme/toptas/fancyshowcase/internal/Presenter;", "", "pref", "Lme/toptas/fancyshowcase/internal/SharedPref;", "device", "Lme/toptas/fancyshowcase/internal/DeviceParams;", "props", "Lme/toptas/fancyshowcase/internal/Properties;", "(Lme/toptas/fancyshowcase/internal/SharedPref;Lme/toptas/fancyshowcase/internal/DeviceParams;Lme/toptas/fancyshowcase/internal/Properties;)V", "bitmapHeight", "", "getBitmapHeight", "()I", "setBitmapHeight", "(I)V", "bitmapWidth", "getBitmapWidth", "setBitmapWidth", "centerX", "getCenterX", "setCenterX", "centerY", "getCenterY", "setCenterY", "circleCenterX", "getCircleCenterX", "setCircleCenterX", "circleCenterY", "getCircleCenterY", "setCircleCenterY", "focusHeight", "getFocusHeight", "setFocusHeight", "focusShape", "Lme/toptas/fancyshowcase/FocusShape;", "getFocusShape", "()Lme/toptas/fancyshowcase/FocusShape;", "setFocusShape", "(Lme/toptas/fancyshowcase/FocusShape;)V", "focusWidth", "getFocusWidth", "setFocusWidth", "hasFocus", "", "getHasFocus", "()Z", "setHasFocus", "(Z)V", "viewRadius", "getViewRadius", "setViewRadius", "calcAutoTextPosition", "Lme/toptas/fancyshowcase/internal/AutoTextPosition;", "calculations", "", "circleRadius", "", "animCounter", "", "animMoveFactor", "getCircleCenter", "Lme/toptas/fancyshowcase/internal/CircleCenter;", "view", "Lme/toptas/fancyshowcase/internal/IFocusedView;", "initialize", "isWithinZone", "x", "y", "clickableView", "roundRectBottom", "roundRectLeft", "roundRectRight", "roundRectTop", "setCirclePosition", "positionX", "positionY", "radius", "setFocusPositions", "setRectPosition", "rectWidth", "rectHeight", "show", "onShow", "Lkotlin/Function0;", "writeShown", "fancyId", "", "fancyshowcaseview_release"})
public final class Presenter {
    private int centerX;
    private int centerY;
    private boolean hasFocus;
    private int circleCenterX;
    private int circleCenterY;
    @NotNull
    private FocusShape focusShape;
    private int bitmapWidth;
    private int bitmapHeight;
    private int focusWidth;
    private int focusHeight;
    private int viewRadius;
    private final SharedPref pref;
    private final DeviceParams device;
    private final Properties props;

    public final int getCenterX() {
        return this.centerX;
    }

    public final void setCenterX(int n) {
        this.centerX = n;
    }

    public final int getCenterY() {
        return this.centerY;
    }

    public final void setCenterY(int n) {
        this.centerY = n;
    }

    public final boolean getHasFocus() {
        return this.hasFocus;
    }

    public final void setHasFocus(boolean bl) {
        this.hasFocus = bl;
    }

    public final int getCircleCenterX() {
        return this.circleCenterX;
    }

    public final void setCircleCenterX(int n) {
        this.circleCenterX = n;
    }

    public final int getCircleCenterY() {
        return this.circleCenterY;
    }

    public final void setCircleCenterY(int n) {
        this.circleCenterY = n;
    }

    @NotNull
    public final FocusShape getFocusShape() {
        return this.focusShape;
    }

    public final void setFocusShape(@NotNull FocusShape focusShape) {
        Intrinsics.checkNotNullParameter((Object)((Object)focusShape), (String)"<set-?>");
        this.focusShape = focusShape;
    }

    public final int getBitmapWidth() {
        return this.bitmapWidth;
    }

    public final void setBitmapWidth(int n) {
        this.bitmapWidth = n;
    }

    public final int getBitmapHeight() {
        return this.bitmapHeight;
    }

    public final void setBitmapHeight(int n) {
        this.bitmapHeight = n;
    }

    public final int getFocusWidth() {
        return this.focusWidth;
    }

    public final void setFocusWidth(int n) {
        this.focusWidth = n;
    }

    public final int getFocusHeight() {
        return this.focusHeight;
    }

    public final void setFocusHeight(int n) {
        this.focusHeight = n;
    }

    public final int getViewRadius() {
        return this.viewRadius;
    }

    public final void setViewRadius(int n) {
        this.viewRadius = n;
    }

    public final void initialize() {
        this.props.setBackgroundColor(this.props.getBackgroundColor() != 0 ? this.props.getBackgroundColor() : this.device.currentBackgroundColor());
        this.props.setTitleGravity(this.props.getTitleGravity() >= 0 ? this.props.getTitleGravity() : 17);
        this.props.setTitleStyle(this.props.getTitleStyle() != 0 ? this.props.getTitleStyle() : R.style.FancyShowCaseDefaultTitleStyle);
        this.centerX = this.device.deviceWidth() / 2;
        this.centerY = this.device.deviceHeight() / 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void show(@NotNull Function0<Unit> onShow) {
        Intrinsics.checkNotNullParameter(onShow, (String)"onShow");
        if (this.pref.isShownBefore(this.props.getFancyId())) {
            DismissListener dismissListener = this.props.getDismissListener();
            if (dismissListener != null) {
                dismissListener.onSkipped(this.props.getFancyId());
            }
            OnQueueListener onQueueListener = this.props.getQueueListener();
            if (onQueueListener == null) return;
            onQueueListener.onNext();
            return;
        }
        IFocusedView iFocusedView = this.props.getFocusedView();
        if (iFocusedView != null) {
            if (iFocusedView.cantFocus()) {
                IFocusedView iFocusedView2 = this.props.getFocusedView();
                if (iFocusedView2 == null) return;
                iFocusedView2.waitForLayout((Function0<Unit>)((Function0)new Function0<Unit>(onShow){
                    final /* synthetic */ Function0 $onShow;

                    public final void invoke() {
                        this.$onShow.invoke();
                    }
                    {
                        this.$onShow = function0;
                        super(0);
                    }
                }));
                return;
            }
        }
        onShow.invoke();
    }

    public final void calculations() {
        int deviceWidth = this.device.deviceWidth();
        int deviceHeight = this.device.deviceHeight();
        this.bitmapWidth = deviceWidth;
        this.bitmapHeight = deviceHeight - (this.props.getFitSystemWindows() ? 0 : this.device.getStatusBarHeight());
        if (this.props.getFocusedView() != null) {
            IFocusedView iFocusedView = this.props.getFocusedView();
            Intrinsics.checkNotNull((Object)iFocusedView);
            this.focusWidth = (int)((double)iFocusedView.width() * this.props.getFocusRectSizeFactor());
            IFocusedView iFocusedView2 = this.props.getFocusedView();
            Intrinsics.checkNotNull((Object)iFocusedView2);
            this.focusHeight = (int)((double)iFocusedView2.height() * this.props.getFocusRectSizeFactor());
            IFocusedView iFocusedView3 = this.props.getFocusedView();
            if (iFocusedView3 != null) {
                IFocusedView iFocusedView4 = iFocusedView3;
                boolean bl = false;
                boolean bl2 = false;
                IFocusedView $this$apply = iFocusedView4;
                boolean bl3 = false;
                CircleCenter center = this.getCircleCenter($this$apply);
                this.circleCenterX = center.getX();
                this.circleCenterY = center.getY();
            }
            IFocusedView iFocusedView5 = this.props.getFocusedView();
            Intrinsics.checkNotNull((Object)iFocusedView5);
            double d = iFocusedView5.width();
            IFocusedView iFocusedView6 = this.props.getFocusedView();
            Intrinsics.checkNotNull((Object)iFocusedView6);
            double d2 = iFocusedView6.height();
            boolean bl = false;
            this.viewRadius = (int)((double)((int)(Math.hypot(d, d2) / (double)2)) * this.props.getFocusCircleRadiusFactor());
            this.hasFocus = true;
        } else {
            this.hasFocus = false;
        }
    }

    public final void writeShown(@Nullable String fancyId) {
        block0: {
            String string = fancyId;
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            this.pref.writeShown(it);
        }
    }

    private final void setRectPosition(int positionX, int positionY, int rectWidth, int rectHeight) {
        this.circleCenterX = positionX;
        this.circleCenterY = positionY;
        this.focusWidth = rectWidth;
        this.focusHeight = rectHeight;
        this.focusShape = FocusShape.ROUNDED_RECTANGLE;
        this.hasFocus = true;
    }

    private final void setCirclePosition(int positionX, int positionY, int radius) {
        this.circleCenterX = positionX;
        this.viewRadius = radius;
        this.circleCenterY = positionY;
        this.focusShape = FocusShape.CIRCLE;
        this.hasFocus = true;
    }

    public final float circleRadius(double animCounter, double animMoveFactor) {
        return (float)((double)this.viewRadius + animCounter * animMoveFactor);
    }

    public final float roundRectLeft(double animCounter, double animMoveFactor) {
        return (float)((double)this.circleCenterX - (double)(this.focusWidth / 2) - animCounter * animMoveFactor);
    }

    public final float roundRectTop(double animCounter, double animMoveFactor) {
        return (float)((double)this.circleCenterY - (double)(this.focusHeight / 2) - animCounter * animMoveFactor);
    }

    public final float roundRectRight(double animCounter, double animMoveFactor) {
        return (float)((double)this.circleCenterX + (double)(this.focusWidth / 2) + animCounter * animMoveFactor);
    }

    public final float roundRectBottom(double animCounter, double animMoveFactor) {
        return (float)((double)this.circleCenterY + (double)(this.focusHeight / 2) + animCounter * animMoveFactor);
    }

    @NotNull
    public final CircleCenter getCircleCenter(@NotNull IFocusedView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        boolean shouldAdjustYPosition = this.props.getFitSystemWindows() && this.device.aboveAPI19() || this.device.isFullScreen() && !this.props.getFitSystemWindows();
        int adjustHeight = shouldAdjustYPosition ? 0 : this.device.getStatusBarHeight();
        int[] viewPoint = new int[2];
        int[] point = view.getLocationInWindow(viewPoint);
        CircleCenter center = new CircleCenter(0, 0);
        center.setX(point[0] + view.width() / 2);
        center.setY(point[1] + view.height() / 2 - adjustHeight);
        return center;
    }

    public final boolean isWithinZone(float x, float y, @NotNull IFocusedView clickableView) {
        Intrinsics.checkNotNullParameter((Object)clickableView, (String)"clickableView");
        boolean isWithin = false;
        CircleCenter viewCenter = this.getCircleCenter(clickableView);
        int focusCenterX = viewCenter.getX();
        int focusCenterY = viewCenter.getY();
        int focusWidth = clickableView.width();
        int focusHeight = clickableView.height();
        float focusRadius = FocusShape.CIRCLE == this.props.getFocusShape() ? this.circleRadius(0.0, 1.0) : 0.0f;
        switch (Presenter$WhenMappings.$EnumSwitchMapping$0[this.props.getFocusShape().ordinal()]) {
            case 1: {
                double d = (float)focusCenterX - x;
                double d2 = 2.0;
                boolean bl = false;
                double d3 = Math.pow(d, d2);
                d = (float)focusCenterY - y;
                d2 = 2.0;
                bl = false;
                d = d3 + Math.pow(d, d2);
                boolean bl2 = false;
                double distance = Math.sqrt(d);
                boolean bl3 = false;
                isWithin = Math.abs(distance) < (double)focusRadius;
                break;
            }
            case 2: {
                Rect rect = new Rect();
                int left = focusCenterX - focusWidth / 2;
                int right = focusCenterX + focusWidth / 2;
                int top = focusCenterY - focusHeight / 2;
                int bottom = focusCenterY + focusHeight / 2;
                rect.set(left, top, right, bottom);
                isWithin = rect.contains((int)x, (int)y);
                break;
            }
        }
        return isWithin;
    }

    public final void setFocusPositions() {
        if (this.props.getFocusRectangleWidth() > 0 && this.props.getFocusRectangleHeight() > 0) {
            this.setRectPosition(this.props.getFocusPositionX(), this.props.getFocusPositionY(), this.props.getFocusRectangleWidth(), this.props.getFocusRectangleHeight());
        }
        if (this.props.getFocusCircleRadius() > 0) {
            this.setCirclePosition(this.props.getFocusPositionX(), this.props.getFocusPositionY(), this.props.getFocusCircleRadius());
        }
    }

    @NotNull
    public final AutoTextPosition calcAutoTextPosition() {
        float top = this.roundRectTop(0.0, 0.0);
        float bottom = this.roundRectBottom(0.0, 0.0);
        int spaceAbove = (int)top;
        int spaceBelow = this.bitmapHeight - (int)bottom;
        int halfViewHeight = this.focusShape == FocusShape.ROUNDED_RECTANGLE ? this.focusHeight / 2 : this.viewRadius;
        AutoTextPosition autoPos = new AutoTextPosition(0, 0, 0, 7, null);
        if (spaceAbove > spaceBelow) {
            autoPos.setBottomMargin(this.bitmapHeight - (this.circleCenterY + halfViewHeight));
            autoPos.setTopMargin(0);
            autoPos.setHeight((int)top);
        } else {
            autoPos.setTopMargin(this.circleCenterY + halfViewHeight);
            autoPos.setBottomMargin(0);
            autoPos.setHeight((int)((float)this.bitmapHeight - top));
        }
        return autoPos;
    }

    public Presenter(@NotNull SharedPref pref, @NotNull DeviceParams device, @NotNull Properties props) {
        Intrinsics.checkNotNullParameter((Object)pref, (String)"pref");
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this.pref = pref;
        this.device = device;
        this.props = props;
        this.focusShape = this.props.getFocusShape();
    }
}

