/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.github.fakemongo.Fongo;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoCollectionImpl;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.util.FongoJSON;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class FongoMongoCollection<TDocument>
extends MongoCollectionImpl<TDocument> {
    private final Fongo fongo;
    private final DBCollection dbCollection;

    FongoMongoCollection(Fongo fongo, MongoNamespace namespace, Class<TDocument> tDocumentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern) {
        super(namespace, tDocumentClass, codecRegistry, readPreference, writeConcern, (OperationExecutor)fongo);
        this.fongo = fongo;
        this.dbCollection = fongo.getDB(namespace.getDatabaseName()).getCollection(namespace.getCollectionName());
    }

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> clazz) {
        return new FongoMongoCollection<NewTDocument>(this.fongo, super.getNamespace(), clazz, super.getCodecRegistry(), super.getReadPreference(), super.getWriteConcern());
    }

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new FongoMongoCollection<TDocument>(this.fongo, super.getNamespace(), super.getDocumentClass(), codecRegistry, super.getReadPreference(), super.getWriteConcern());
    }

    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new FongoMongoCollection<TDocument>(this.fongo, super.getNamespace(), super.getDocumentClass(), super.getCodecRegistry(), readPreference, super.getWriteConcern());
    }

    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new FongoMongoCollection<TDocument>(this.fongo, super.getNamespace(), super.getDocumentClass(), super.getCodecRegistry(), super.getReadPreference(), writeConcern);
    }

    public long count(Bson filter, CountOptions options) {
        DBObject query = this.dbObject(filter);
        int limit = options.getLimit();
        int skip = options.getSkip();
        return this.dbCollection.getCount(query, null, (long)limit, (long)skip);
    }

    public List<String> createIndexes(List<IndexModel> indexes) {
        for (IndexModel indexModel : indexes) {
            this.dbCollection.createIndex(this.dbObject(indexModel.getKeys()), indexModel.getOptions().getName(), indexModel.getOptions().isUnique());
        }
        return super.createIndexes(indexes);
    }

    private DBObject dbObject(Bson bson) {
        if (bson == null) {
            return null;
        }
        return (DBObject)FongoJSON.parse(bson.toBsonDocument(Document.class, super.getCodecRegistry()).toString());
    }
}

