/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import java.time.Instant;

public final class UuidTime {
    public static final Instant EPOCH_UNIX = Instant.parse("1970-01-01T00:00:00.000Z");
    public static final Instant EPOCH_GREG = Instant.parse("1582-10-15T00:00:00.000Z");
    public static final long EPOCH_UNIX_SECONDS = EPOCH_UNIX.getEpochSecond();
    public static final long EPOCH_GREG_SECONDS = EPOCH_GREG.getEpochSecond();
    public static final long NANOS_PER_TICK = 100L;
    public static final long TICKS_PER_MILLI = 10000L;
    public static final long TICKS_PER_SECOND = 10000000L;

    private UuidTime() {
    }

    public static long getUnixTimestamp() {
        return UuidTime.toUnixTimestamp(Instant.now());
    }

    public static long getGregTimestamp() {
        return UuidTime.toGregTimestamp(Instant.now());
    }

    public static long toUnixTimestamp(long gregTimestamp) {
        return gregTimestamp + EPOCH_GREG_SECONDS * 10000000L;
    }

    public static long toGregTimestamp(long unixTimestamp) {
        return unixTimestamp - EPOCH_GREG_SECONDS * 10000000L;
    }

    public static long toUnixTimestamp(Instant instant) {
        long seconds = instant.getEpochSecond() * 10000000L;
        long nanos = (long)instant.getNano() / 100L;
        return seconds + nanos;
    }

    public static long toGregTimestamp(Instant instant) {
        long seconds = (instant.getEpochSecond() - EPOCH_GREG_SECONDS) * 10000000L;
        long nanos = (long)instant.getNano() / 100L;
        return seconds + nanos;
    }

    public static Instant fromUnixTimestamp(long unixTimestamp) {
        long seconds = unixTimestamp / 10000000L;
        long nanos = unixTimestamp % 10000000L * 100L;
        return Instant.ofEpochSecond(seconds, nanos);
    }

    public static Instant fromGregTimestamp(long gregTimestamp) {
        long seconds = gregTimestamp / 10000000L + EPOCH_GREG_SECONDS;
        long nanos = gregTimestamp % 10000000L * 100L;
        return Instant.ofEpochSecond(seconds, nanos);
    }
}

