/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.standard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import java.time.Clock;
import java.time.Instant;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

public final class TimeOrderedEpochFactory
extends AbstCombFactory {
    private final UuidFunction uuidFunction;
    private static final int INCREMENT_TYPE_DEFAULT = 0;
    private static final int INCREMENT_TYPE_PLUS_1 = 1;
    private static final int INCREMENT_TYPE_PLUS_N = 2;
    private static final long INCREMENT_MAX_DEFAULT = 0xFFFFFFFFL;
    private static final long versionBits = 61440L;
    private static final long variantBits = -4611686018427387904L;
    private static final long upper16Bits = -281474976710656L;
    private static final long upper48Bits = -65536L;

    public TimeOrderedEpochFactory() {
        this(TimeOrderedEpochFactory.builder());
    }

    public TimeOrderedEpochFactory(Clock clock) {
        this((Builder)TimeOrderedEpochFactory.builder().withClock(clock));
    }

    public TimeOrderedEpochFactory(Random random) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandom(random));
    }

    public TimeOrderedEpochFactory(Random random, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandom(random)).withClock(clock));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction) {
        this((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction));
    }

    public TimeOrderedEpochFactory(LongSupplier randomFunction, Clock clock) {
        this((Builder)((Builder)TimeOrderedEpochFactory.builder().withRandomFunction(randomFunction)).withClock(clock));
    }

    private TimeOrderedEpochFactory(Builder builder) {
        super(UuidVersion.VERSION_TIME_ORDERED_EPOCH, builder);
        switch (builder.getIncrementType()) {
            case 1: {
                this.uuidFunction = new Plus1Function(this.random, this.instantFunction);
                break;
            }
            case 2: {
                this.uuidFunction = new PlusNFunction(this.random, this.instantFunction, builder.getIncrementMax());
                break;
            }
            default: {
                this.uuidFunction = new DefaultFunction(this.random, this.instantFunction);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        UUID uuid = this.uuidFunction.apply((Instant)this.instantFunction.get());
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    @Override
    public UUID create(UuidFactory.Parameters parameters) {
        Objects.requireNonNull(parameters.getInstant(), "Null instant");
        UUID uuid = this.uuidFunction.apply(parameters.getInstant());
        return this.toUuid(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    static final class PlusNFunction
    extends UuidFunction {
        private final LongSupplier plusNFunction;

        public PlusNFunction(AbstRandomBasedFactory.IRandom random, Supplier<Instant> instantFunction, Long incrementMax) {
            super(random, instantFunction);
            this.plusNFunction = this.customPlusNFunction(random, incrementMax);
        }

        @Override
        void increment(Instant instant) {
            this.microseconds(instant);
            this.lsb = (this.lsb | 0xC000000000000000L) + this.plusNFunction.getAsLong();
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
        }

        private LongSupplier customPlusNFunction(AbstRandomBasedFactory.IRandom random, Long incrementMax) {
            if (incrementMax == 0xFFFFFFFFL) {
                if (random instanceof AbstRandomBasedFactory.SafeRandom) {
                    return () -> random.nextLong(4) + 1L;
                }
                return () -> (random.nextLong() >>> 32) + 1L;
            }
            long positive = Long.MAX_VALUE;
            if (random instanceof AbstRandomBasedFactory.SafeRandom) {
                int bits = (int)Math.ceil(Math.log(incrementMax.longValue()) / Math.log(2.0));
                int size = (bits - 1) / 8 + 1;
                return () -> (random.nextLong(size) & Long.MAX_VALUE) % incrementMax + 1L;
            }
            return () -> (random.nextLong() & Long.MAX_VALUE) % incrementMax + 1L;
        }
    }

    static final class Plus1Function
    extends UuidFunction {
        public Plus1Function(AbstRandomBasedFactory.IRandom random, Supplier<Instant> instantFunction) {
            super(random, instantFunction);
        }

        @Override
        void increment(Instant instant) {
            this.microseconds(instant);
            this.lsb = (this.lsb | 0xC000000000000000L) + 1L;
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
        }
    }

    static final class DefaultFunction
    extends UuidFunction {
        public DefaultFunction(AbstRandomBasedFactory.IRandom random, Supplier<Instant> instantFunction) {
            super(random, instantFunction);
        }

        @Override
        void increment(Instant instant) {
            this.microseconds(instant);
            this.lsb &= 0xFFFF000000000000L;
            this.lsb = (this.lsb | 0xC000000000000000L) + 0x1000000000000L;
            if (this.lsb == 0L) {
                this.msb = (this.msb | 0xF000L) + 1L;
            }
            this.lsb = this.lsb & 0xFFFF000000000000L | this.random.nextLong(6);
        }
    }

    static abstract class UuidFunction
    implements Function<Instant, UUID> {
        protected long msb = 0L;
        protected long lsb = 0L;
        protected final AbstRandomBasedFactory.IRandom random;
        protected Supplier<Instant> instantFunction;
        protected final ReentrantLock lock = new ReentrantLock();
        private static final long advanceMax = 1000L;
        protected static final int precision = UuidFunction.precision();
        protected static final int PRECISION_MILLISECOND = 1;
        protected static final int PRECISION_MICROSECOND = 2;
        protected static final long overflow = 0L;

        public UuidFunction(AbstRandomBasedFactory.IRandom random, Supplier<Instant> instantFunction) {
            this.random = random;
            this.instantFunction = instantFunction;
            this.reset(this.instantFunction.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UUID apply(Instant instant) {
            this.lock.lock();
            try {
                long lastTime = this.lastTime();
                long time = instant.toEpochMilli();
                if (1000L > Math.abs(lastTime - time)) {
                    time = Math.max(lastTime, time);
                }
                if (time == lastTime) {
                    this.increment(instant);
                } else {
                    this.reset(instant);
                }
                UUID uUID = new UUID(this.msb, this.lsb);
                return uUID;
            }
            finally {
                this.lock.unlock();
            }
        }

        abstract void increment(Instant var1);

        void reset(Instant instant) {
            this.msb = instant.toEpochMilli() << 16;
            this.lsb = this.random.nextLong();
            if (precision == 1) {
                this.msb = this.msb & 0xFFFFFFFFFFFF0000L | this.random.nextLong(2);
            } else {
                this.microseconds(instant);
            }
        }

        void microseconds(Instant instant) {
            long prev;
            if (precision == 1) {
                return;
            }
            long shift = 12L;
            long scale = 1000000L;
            long nanos = instant.getNano();
            long randa = (nanos % 1000000L << 12) / 1000000L;
            long next = this.msb & 0xFFFFFFFFFFFF0000L | randa & 0xFFFL;
            this.msb = next > (prev = this.msb & 0xFFFFFFFFFFFF0FFFL) ? next : prev;
        }

        long lastTime() {
            return this.msb >>> 16;
        }

        static int precision() {
            Clock clock = Clock.systemUTC();
            int best = 0;
            int loop = 3;
            for (int i = 0; i < loop; ++i) {
                int x = 0;
                int nanosecond = clock.instant().getNano();
                x = nanosecond % 1000000 != 0 ? 2 : 1;
                best = Math.max(best, x);
            }
            return best;
        }
    }

    public static class Builder
    extends AbstCombFactory.Builder<TimeOrderedEpochFactory, Builder> {
        private Integer incrementType;
        private Long incrementMax;

        public Builder withIncrementPlus1() {
            this.incrementType = 1;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN() {
            this.incrementType = 2;
            this.incrementMax = null;
            return this;
        }

        public Builder withIncrementPlusN(long incrementMax) {
            this.incrementType = 2;
            this.incrementMax = incrementMax;
            return this;
        }

        protected int getIncrementType() {
            if (this.incrementType == null) {
                this.incrementType = 0;
            }
            return this.incrementType;
        }

        protected long getIncrementMax() {
            if (this.incrementMax == null) {
                this.incrementMax = 0xFFFFFFFFL;
            }
            return this.incrementMax;
        }

        @Override
        public TimeOrderedEpochFactory build() {
            return new TimeOrderedEpochFactory(this);
        }
    }
}

