/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.codec.base.Base16Codec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.immutable.ByteArray;
import java.util.UUID;

public final class UuidValidator {
    private static final ByteArray MAP = Base16Codec.INSTANCE.getBase().getMap();
    private static final int[] DASH_POSITIONS = new int[]{8, 13, 18, 23};
    private static final int WITH_DASH_UUID_LENGTH = 36;
    private static final int WITHOUT_DASH_UUID_LENGTH = 32;
    private static final int MAX_DASH_COUNT = 4;

    private UuidValidator() {
    }

    public static boolean isValid(UUID uuid) {
        return uuid != null;
    }

    public static boolean isValid(UUID uuid, int version) {
        return uuid != null && UuidValidator.isVersion(uuid, version);
    }

    public static boolean isValid(byte[] uuid) {
        return uuid != null && uuid.length == 16;
    }

    public static boolean isValid(byte[] uuid, int version) {
        return uuid != null && uuid.length == 16 && UuidValidator.isVersion(uuid, version);
    }

    public static boolean isValid(String uuid) {
        return uuid != null && uuid.length() != 0 && UuidValidator.isParseable(uuid.toCharArray());
    }

    public static boolean isValid(String uuid, int version) {
        return uuid != null && uuid.length() != 0 && UuidValidator.isParseable(uuid.toCharArray(), version);
    }

    public static boolean isValid(char[] uuid) {
        return uuid != null && uuid.length != 0 && UuidValidator.isParseable(uuid);
    }

    public static boolean isValid(char[] uuid, int version) {
        return uuid != null && uuid.length != 0 && UuidValidator.isParseable(uuid, version);
    }

    public static void validate(UUID uuid) {
        if (uuid == null) {
            throw InvalidUuidException.newInstance(null);
        }
    }

    public static void validate(UUID uuid, int version) {
        if (uuid == null || !UuidValidator.isVersion(uuid, version)) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(byte[] uuid) {
        if (uuid == null || uuid.length != 16) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(byte[] uuid, int version) {
        if (uuid == null || uuid.length != 16 || !UuidValidator.isVersion(uuid, version)) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(String uuid) {
        if (uuid == null || !UuidValidator.isParseable(uuid.toCharArray())) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(String uuid, int version) {
        if (uuid == null || !UuidValidator.isParseable(uuid.toCharArray(), version)) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(char[] uuid) {
        if (uuid == null || !UuidValidator.isParseable(uuid)) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    public static void validate(char[] uuid, int version) {
        if (uuid == null || !UuidValidator.isParseable(uuid, version)) {
            throw InvalidUuidException.newInstance(uuid);
        }
    }

    protected static boolean isParseable(char[] chars) {
        int dashCount = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (MAP.get(chars[i]) != -1) continue;
            if (chars[i] == '-') {
                ++dashCount;
                continue;
            }
            return false;
        }
        if (chars.length == 36 && dashCount == 4) {
            return chars[DASH_POSITIONS[0]] == '-' && chars[DASH_POSITIONS[1]] == '-' && chars[DASH_POSITIONS[2]] == '-' && chars[DASH_POSITIONS[3]] == '-';
        }
        return chars.length == 32 && dashCount == 0;
    }

    protected static boolean isParseable(char[] chars, int version) {
        return UuidValidator.isVersion(chars, version) && UuidValidator.isParseable(chars);
    }

    protected static boolean isVersion(UUID uuid, int version) {
        boolean versionOk = (version & 0xFFFFFFF0) == 0 && uuid.version() == version;
        boolean variantOk = uuid.variant() == 2;
        return versionOk && variantOk;
    }

    protected static boolean isVersion(byte[] bytes, int version) {
        boolean versionOk = (version & 0xFFFFFFF0) == 0 && (bytes[6] & 0xFF) >>> 4 == version;
        boolean variantOk = (bytes[8] & 0xFF) >>> 6 == 2;
        return versionOk && variantOk;
    }

    protected static boolean isVersion(char[] chars, int version) {
        if ((version & 0xFFFFFFF0) != 0) {
            return false;
        }
        int ver = 0;
        int var = 0;
        switch (chars.length) {
            case 32: {
                ver = 12;
                var = 16;
                break;
            }
            case 36: {
                ver = 14;
                var = 19;
                break;
            }
            default: {
                return false;
            }
        }
        char[] lower = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] upper = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        boolean versionOk = (version & 0xFFFFFFF0) == 0 && (chars[ver] == lower[version] || chars[ver] == upper[version]);
        boolean variantOk = chars[var] == '8' || chars[var] == '9' || chars[var] == 'a' || chars[var] == 'b' || chars[var] == 'A' || chars[var] == 'B';
        return versionOk && variantOk;
    }
}

