/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.rfc4122;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstRandomBasedFactory;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.util.Random;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;

public final class RandomBasedFactory
extends AbstRandomBasedFactory {
    public RandomBasedFactory() {
        this(RandomBasedFactory.builder());
    }

    public RandomBasedFactory(Random random) {
        this((Builder)RandomBasedFactory.builder().withRandom(random));
    }

    public RandomBasedFactory(LongSupplier randomSupplier) {
        this((Builder)RandomBasedFactory.builder().withRandomFunction(randomSupplier));
    }

    public RandomBasedFactory(IntFunction<byte[]> randomFunction) {
        this((Builder)RandomBasedFactory.builder().withRandomFunction((IntFunction)randomFunction));
    }

    private RandomBasedFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID create() {
        this.lock.lock();
        try {
            if (this.random instanceof AbstRandomBasedFactory.ByteRandom) {
                byte[] bytes = this.random.nextBytes(16);
                long msb = ByteUtil.toNumber(bytes, 0, 8);
                long lsb = ByteUtil.toNumber(bytes, 8, 16);
                UUID uUID = this.toUuid(msb, lsb);
                return uUID;
            }
            long msb = this.random.nextLong();
            long lsb = this.random.nextLong();
            UUID uUID = this.toUuid(msb, lsb);
            return uUID;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static class Builder
    extends AbstRandomBasedFactory.Builder<RandomBasedFactory, Builder> {
        @Override
        public RandomBasedFactory build() {
            return new RandomBasedFactory(this);
        }
    }
}

