/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec;

import com.github.f4b6a3.uuid.codec.StringCodec;
import com.github.f4b6a3.uuid.codec.UuidCodec;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidValidator;
import java.util.UUID;

public class UrnCodec
implements UuidCodec<String> {
    public static final UrnCodec INSTANCE = new UrnCodec();
    private static final String URN_PREFIX = "urn:uuid:";

    @Override
    public String encode(UUID uuid) {
        UuidValidator.validate(uuid);
        return URN_PREFIX + StringCodec.INSTANCE.encode(uuid);
    }

    @Override
    public UUID decode(String urn) {
        if (!UrnCodec.isUuidUrn(urn)) {
            throw InvalidUuidException.newInstance(urn);
        }
        return StringCodec.INSTANCE.decode(urn);
    }

    public static boolean isUuidUrn(String urn) {
        int stringLength = 45;
        int prefixLength = 9;
        if (urn != null && urn.length() == 45) {
            String uuid = urn.substring(9);
            return UuidValidator.isValid(uuid);
        }
        return false;
    }
}

