/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class ShortPrefixCombFactory
extends AbstCombFactory {
    protected final int interval;
    protected static final int DEFAULT_INTERVAL = 60000;

    public ShortPrefixCombFactory() {
        this(ShortPrefixCombFactory.builder());
    }

    public ShortPrefixCombFactory(Clock clock) {
        this(ShortPrefixCombFactory.builder().withClock(clock));
    }

    public ShortPrefixCombFactory(Random random) {
        this(ShortPrefixCombFactory.builder().withRandom(random));
    }

    public ShortPrefixCombFactory(Random random, Clock clock) {
        this(ShortPrefixCombFactory.builder().withRandom(random).withClock(clock));
    }

    public ShortPrefixCombFactory(RandomFunction randomFunction) {
        this(ShortPrefixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public ShortPrefixCombFactory(RandomFunction randomFunction, Clock clock) {
        this(ShortPrefixCombFactory.builder().withRandomFunction(randomFunction).withClock(clock));
    }

    private ShortPrefixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
        this.interval = builder.getInterval();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(14);
        long msb = ByteUtil.toNumber(bytes, 8, 14);
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        long timestamp = this.clock.millis() / (long)this.interval;
        return this.toUuid(msb |= (timestamp & 0xFFFFL) << 48, lsb);
    }

    public static class Builder
    extends AbstCombFactory.Builder<ShortPrefixCombFactory> {
        private Integer interval;

        protected int getInterval() {
            if (this.interval == null) {
                this.interval = 60000;
            }
            return this.interval;
        }

        public Builder withClock(Clock clock) {
            return (Builder)super.withClock(clock);
        }

        public Builder withRandom(Random random) {
            return (Builder)super.withRandom(random);
        }

        public Builder withRandomFunction(RandomFunction randomFunction) {
            return (Builder)super.withRandomFunction(randomFunction);
        }

        public Builder withInterval(int interval) {
            this.interval = interval;
            return this;
        }

        @Override
        public ShortPrefixCombFactory build() {
            return new ShortPrefixCombFactory(this);
        }
    }
}

