/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.nonstandard;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.AbstCombFactory;
import com.github.f4b6a3.uuid.factory.function.RandomFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.time.Clock;
import java.util.Random;
import java.util.UUID;

public final class PrefixCombFactory
extends AbstCombFactory {
    public PrefixCombFactory() {
        this(PrefixCombFactory.builder());
    }

    public PrefixCombFactory(Clock clock) {
        this(PrefixCombFactory.builder().withClock(clock));
    }

    public PrefixCombFactory(Random random) {
        this(PrefixCombFactory.builder().withRandom(random));
    }

    public PrefixCombFactory(Random random, Clock clock) {
        this(PrefixCombFactory.builder().withRandom(random).withClock(clock));
    }

    public PrefixCombFactory(RandomFunction randomFunction) {
        this(PrefixCombFactory.builder().withRandomFunction(randomFunction));
    }

    public PrefixCombFactory(RandomFunction randomFunction, Clock clock) {
        this(PrefixCombFactory.builder().withRandomFunction(randomFunction).withClock(clock));
    }

    private PrefixCombFactory(Builder builder) {
        super(UuidVersion.VERSION_RANDOM_BASED, builder);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public UUID create() {
        byte[] bytes = (byte[])this.randomFunction.apply(10);
        long msb = ((long)bytes[8] & 0xFFL) << 8 | (long)bytes[9] & 0xFFL;
        long lsb = ByteUtil.toNumber(bytes, 0, 8);
        long timestamp = this.clock.millis();
        return this.toUuid(msb |= (timestamp & 0xFFFFFFFFFFFFL) << 16, lsb);
    }

    public static class Builder
    extends AbstCombFactory.Builder<PrefixCombFactory> {
        public Builder withClock(Clock clock) {
            return (Builder)super.withClock(clock);
        }

        public Builder withRandom(Random random) {
            return (Builder)super.withRandom(random);
        }

        public Builder withRandomFunction(RandomFunction randomFunction) {
            return (Builder)super.withRandomFunction(randomFunction);
        }

        @Override
        public PrefixCombFactory build() {
            return new PrefixCombFactory(this);
        }
    }
}

