/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import com.github.f4b6a3.uuid.util.internal.RandomUtil;
import java.time.Clock;

public final class DefaultTimeFunction
implements TimeFunction {
    private final Clock clock;
    private long prevTime = -1L;
    private long counter = Math.abs(RandomUtil.nextLong() % 10000L);
    private long counterMax = this.counter + 10000L;

    public DefaultTimeFunction() {
        this.clock = Clock.systemUTC();
    }

    public DefaultTimeFunction(Clock clock) {
        this.clock = clock;
    }

    @Override
    public long getAsLong() {
        ++this.counter;
        long time = this.clock.millis();
        if (time == this.prevTime) {
            if (this.counter >= this.counterMax) {
                while (time == this.clock.millis()) {
                }
            }
        } else {
            this.counter %= 10000L;
            this.counterMax = this.counter + 10000L;
        }
        this.prevTime = time;
        return time * 10000L + this.counter;
    }
}

