/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory;

import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.factory.NoArgsFactory;
import com.github.f4b6a3.uuid.factory.UuidFactory;
import com.github.f4b6a3.uuid.factory.function.ClockSeqFunction;
import com.github.f4b6a3.uuid.factory.function.NodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.TimeFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultClockSeqFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.DefaultTimeFunction;
import com.github.f4b6a3.uuid.factory.function.impl.HashNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.MacNodeIdFunction;
import com.github.f4b6a3.uuid.factory.function.impl.RandomNodeIdFunction;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import com.github.f4b6a3.uuid.util.internal.SettingsUtil;
import java.time.Instant;
import java.util.UUID;

public abstract class AbstTimeBasedFactory
extends UuidFactory
implements NoArgsFactory {
    protected TimeFunction timeFunction;
    protected NodeIdFunction nodeidFunction;
    protected ClockSeqFunction clockseqFunction;
    protected final long epochTimestamp;
    public static final Instant EPOCH_UNIX = UuidTime.EPOCH_UNIX;
    public static final Instant EPOCH_GREG = UuidTime.EPOCH_GREG;
    private static final String NODE_MAC = "mac";
    private static final String NODE_HASH = "hash";
    private static final String NODE_RANDOM = "random";

    protected AbstTimeBasedFactory(UuidVersion version, Instant epoch, Builder<?> builder) {
        super(version);
        this.epochTimestamp = TimeFunction.toTimestamp(epoch);
        if (builder != null) {
            this.timeFunction = ((Builder)builder).timeFunction != null ? ((Builder)builder).timeFunction : new DefaultTimeFunction();
            this.clockseqFunction = ((Builder)builder).clockseqFunction != null ? ((Builder)builder).clockseqFunction : new DefaultClockSeqFunction();
            this.nodeidFunction = ((Builder)builder).nodeidFunction != null ? ((Builder)builder).nodeidFunction : AbstTimeBasedFactory.selectNodeIdFunction();
        } else {
            this.timeFunction = new DefaultTimeFunction();
            this.clockseqFunction = new DefaultClockSeqFunction();
            this.nodeidFunction = AbstTimeBasedFactory.selectNodeIdFunction();
        }
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.timeFunction.getAsLong() - this.epochTimestamp;
        long nodeIdentifier = this.nodeidFunction.getAsLong();
        long clockSequence = this.clockseqFunction.applyAsLong(timestamp);
        long msb = this.formatMostSignificantBits(timestamp);
        long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
        return new UUID(msb, lsb);
    }

    public synchronized UUID create(Instant instant, Integer clockseq, Long nodeid) {
        long timestamp = instant != null ? TimeFunction.toTimestamp(instant) - this.epochTimestamp : this.timeFunction.getAsLong() - this.epochTimestamp;
        long nodeIdentifier = nodeid != null ? NodeIdFunction.toExpectedRange(nodeid) : this.nodeidFunction.getAsLong();
        long clockSequence = clockseq != null ? ClockSeqFunction.toExpectedRange(clockseq.intValue()) : this.clockseqFunction.applyAsLong(timestamp);
        long msb = this.formatMostSignificantBits(timestamp);
        long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
        return new UUID(msb, lsb);
    }

    protected long formatMostSignificantBits(long timestamp) {
        return (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
    }

    protected long formatLeastSignificantBits(long nodeIdentifier, long clockSequence) {
        return (clockSequence << 48 | nodeIdentifier & 0xFFFFFFFFFFFFL) & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected static NodeIdFunction selectNodeIdFunction() {
        String string = SettingsUtil.getProperty("node");
        if (NODE_MAC.equalsIgnoreCase(string)) {
            return new MacNodeIdFunction();
        }
        if (NODE_HASH.equalsIgnoreCase(string)) {
            return new HashNodeIdFunction();
        }
        if (NODE_RANDOM.equalsIgnoreCase(string)) {
            return new RandomNodeIdFunction();
        }
        Long number = SettingsUtil.getNodeIdentifier();
        if (number != null) {
            long nodeid = NodeIdFunction.toExpectedRange(number);
            return () -> nodeid;
        }
        return new DefaultNodeIdFunction();
    }

    public static abstract class Builder<T> {
        private TimeFunction timeFunction;
        private NodeIdFunction nodeidFunction;
        private ClockSeqFunction clockseqFunction;

        public Builder<T> withTimeFunction(TimeFunction timeFunction) {
            this.timeFunction = timeFunction;
            return this;
        }

        public Builder<T> withNodeIdFunction(NodeIdFunction nodeidFunction) {
            this.nodeidFunction = nodeidFunction;
            return this;
        }

        public Builder<T> withClockSeqFunction(ClockSeqFunction clockseqFunction) {
            this.clockseqFunction = clockseqFunction;
            return this;
        }

        public Builder<T> withInstant(Instant instant) {
            long timestamp = TimeFunction.toTimestamp(instant);
            this.timeFunction = () -> timestamp;
            return this;
        }

        public Builder<T> withClockSeq(long clockseq) {
            long clockSequence = ClockSeqFunction.toExpectedRange(clockseq);
            this.clockseqFunction = x -> clockSequence;
            return this;
        }

        public Builder<T> withClockSeq(byte[] clockseq) {
            long clockSequence = ClockSeqFunction.toExpectedRange(ByteUtil.toNumber(clockseq));
            this.clockseqFunction = x -> clockSequence;
            return this;
        }

        public Builder<T> withNodeId(long nodeid) {
            long nodeIdentifier = NodeIdFunction.toExpectedRange(nodeid);
            this.nodeidFunction = () -> nodeIdentifier;
            return this;
        }

        public Builder<T> withNodeId(byte[] nodeid) {
            long nodeIdentifier = NodeIdFunction.toExpectedRange(ByteUtil.toNumber(nodeid));
            this.nodeidFunction = () -> nodeIdentifier;
            return this;
        }

        public Builder<T> withMacNodeId() {
            this.nodeidFunction = new MacNodeIdFunction();
            return this;
        }

        public Builder<T> withHashNodeId() {
            this.nodeidFunction = new HashNodeIdFunction();
            return this;
        }

        public Builder<T> withRandomNodeId() {
            this.nodeidFunction = new RandomNodeIdFunction();
            return this;
        }

        public abstract T build();
    }
}

