/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.function.impl;

import com.github.f4b6a3.uuid.factory.function.NodeIdFunction;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public final class MacNodeIdFunction
implements NodeIdFunction {
    private final long nodeIdentifier = this.getHardwareAddress();

    @Override
    public long getAsLong() {
        return this.nodeIdentifier;
    }

    private long getHardwareAddress() {
        try {
            byte[] mac;
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface nic = NetworkInterface.getByInetAddress(ip);
            if (nic != null && !nic.isLoopback() && (mac = nic.getHardwareAddress()) != null && mac.length == 6) {
                return ByteUtil.toNumber(mac);
            }
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                byte[] mac2;
                NetworkInterface next = nics.nextElement();
                if (next == null || next.isLoopback() || (mac2 = next.getHardwareAddress()) == null || mac2.length != 6) continue;
                return ByteUtil.toNumber(mac2);
            }
        }
        catch (SocketException | UnknownHostException iOException) {
            // empty catch block
        }
        return NodeIdFunction.getMulticastRandom();
    }
}

