/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import java.util.UUID;

public final class BaseNRemainderEncoder
extends BaseNEncoder {
    private final int n;
    private static final long HALF_LONG_MASK = 0xFFFFFFFFL;

    public BaseNRemainderEncoder(BaseN base) {
        super(base);
        this.n = base.getRadix();
    }

    @Override
    public String apply(UUID uuid) {
        int[] number = new int[]{(int)(uuid.getMostSignificantBits() >>> 32), (int)(uuid.getMostSignificantBits() & 0xFFFFFFFFL), (int)(uuid.getLeastSignificantBits() >>> 32), (int)(uuid.getLeastSignificantBits() & 0xFFFFFFFFL)};
        char[] buffer = new char[this.base.getLength()];
        int b = buffer.length;
        while (!this.isZero(number)) {
            int[] quotient = new int[4];
            int remainder = this.remainder(number, this.n, quotient);
            buffer[--b] = this.alphabet.get(remainder);
            number = quotient;
        }
        if (b > 0) {
            int padding = b;
            for (int i = 0; i < padding; ++i) {
                buffer[--b] = this.base.getPadding();
            }
        }
        return new String(buffer);
    }

    private int remainder(int[] number, int divisor, int[] quotient) {
        long temporary = 0L;
        long remainder = 0L;
        if (number[0] != 0) {
            temporary = (long)number[0] & 0xFFFFFFFFL;
            quotient[0] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
        }
        if (number[1] != 0 || remainder != 0L) {
            temporary = remainder << 32 | (long)number[1] & 0xFFFFFFFFL;
            quotient[1] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
        }
        if (number[2] != 0 || remainder != 0L) {
            temporary = remainder << 32 | (long)number[2] & 0xFFFFFFFFL;
            quotient[2] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
        }
        if (number[3] != 0 || remainder != 0L) {
            temporary = remainder << 32 | (long)number[3] & 0xFFFFFFFFL;
            quotient[3] = (int)(temporary / (long)divisor);
            remainder = temporary % (long)divisor;
        }
        return (int)remainder;
    }

    private boolean isZero(int[] number) {
        return number[0] == 0 && number[1] == 0 && number[2] == 0 && number[3] == 0;
    }
}

