/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNEncoder;
import java.math.BigInteger;
import java.util.UUID;

public final class BaseNRemainderEncoder
extends BaseNEncoder {
    private final BigInteger n;
    private static final int SIGNUM_POSITIVE = 1;

    public BaseNRemainderEncoder(BaseN base) {
        super(base);
        this.n = BigInteger.valueOf(base.getRadix());
    }

    @Override
    public String apply(UUID uuid) {
        byte[] bytes = BinaryCodec.INSTANCE.encode(uuid);
        BigInteger number = new BigInteger(1, bytes);
        char[] buffer = new char[this.base.getLength()];
        int b = buffer.length;
        while (number.signum() == 1) {
            buffer[--b] = this.alphabet.get(number.remainder(this.n).intValue());
            number = number.divide(this.n);
        }
        if (b > 0) {
            int padding = b;
            for (int i = 0; i < padding; ++i) {
                buffer[--b] = this.base.getPadding();
            }
        }
        return new String(buffer);
    }
}

