/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.BinaryCodec;
import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.codec.base.function.BaseNDecoder;
import java.math.BigInteger;
import java.util.UUID;

public final class BaseNRemainderDecoder
extends BaseNDecoder {
    private final BigInteger n;
    private static final int BYTE_LENGTH = 16;

    public BaseNRemainderDecoder(BaseN base) {
        super(base);
        this.n = BigInteger.valueOf(base.getRadix());
    }

    @Override
    public UUID apply(String string) {
        char[] chars = this.toCharArray(string);
        BigInteger number = BigInteger.ZERO;
        for (char c : chars) {
            long value = this.map.get(c);
            number = this.n.multiply(number).add(BigInteger.valueOf(value));
        }
        byte[] result = number.toByteArray();
        byte[] buffer = new byte[16];
        int r = result.length;
        int b = buffer.length;
        while (--b >= 0 && --r >= 0) {
            buffer[b] = result[r];
        }
        return BinaryCodec.INSTANCE.decode(buffer);
    }
}

