/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.creator.NoArgumentsUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.strategy.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.strategy.NodeIdentifierStrategy;
import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.strategy.clockseq.DefaultClockSequenceStrategy;
import com.github.f4b6a3.uuid.strategy.clockseq.FixedClockSequenceStrategy;
import com.github.f4b6a3.uuid.strategy.nodeid.DefaultNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.strategy.nodeid.FixedNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.strategy.nodeid.HashNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.strategy.nodeid.MacNodeIdentifierStrategy;
import com.github.f4b6a3.uuid.strategy.timestamp.DefaultTimestampStrategy;
import com.github.f4b6a3.uuid.util.UuidTime;
import com.github.f4b6a3.uuid.util.internal.UuidCreatorSettings;
import java.time.Instant;
import java.util.UUID;

public abstract class AbstractTimeBasedUuidCreator
extends AbstractUuidCreator
implements NoArgumentsUuidCreator {
    protected TimestampStrategy timestampStrategy = new DefaultTimestampStrategy();
    protected ClockSequenceStrategy clockSequenceStrategy = new DefaultClockSequenceStrategy();
    protected NodeIdentifierStrategy nodeIdentifierStrategy = AbstractTimeBasedUuidCreator.selectNodeIdentifierStrategy();
    private static final String NODE_MAC = "mac";
    private static final String NODE_HASH = "hash";

    protected AbstractTimeBasedUuidCreator(UuidVersion version) {
        super(version);
    }

    @Override
    public synchronized UUID create() {
        long timestamp = this.timestampStrategy.getTimestamp();
        long nodeIdentifier = this.nodeIdentifierStrategy.getNodeIdentifier();
        long clockSequence = this.clockSequenceStrategy.getClockSequence(timestamp);
        long msb = this.formatMostSignificantBits(timestamp);
        long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
        return new UUID(msb, lsb);
    }

    public UUID create(Instant instant, Integer clockseq, Long nodeid) {
        long timestamp = instant != null ? UuidTime.toTimestamp(instant) : this.timestampStrategy.getTimestamp();
        long nodeIdentifier = nodeid != null ? NodeIdentifierStrategy.setNodeIdentifier(nodeid) : this.nodeIdentifierStrategy.getNodeIdentifier();
        long clockSequence = clockseq != null ? (long)clockseq.intValue() & 0x3FFFL : (long)this.clockSequenceStrategy.getClockSequence(timestamp);
        long msb = this.formatMostSignificantBits(timestamp);
        long lsb = this.formatLeastSignificantBits(nodeIdentifier, clockSequence);
        return new UUID(msb, lsb);
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withNodeIdentifierStrategy(NodeIdentifierStrategy nodeIdentifierStrategy) {
        this.nodeIdentifierStrategy = nodeIdentifierStrategy;
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withClockSequenceStrategy(ClockSequenceStrategy clockSequenceStrategy) {
        this.clockSequenceStrategy = clockSequenceStrategy;
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withNodeIdentifier(long nodeIdentifier) {
        this.nodeIdentifierStrategy = new FixedNodeIdentifierStrategy(nodeIdentifier);
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withNodeIdentifier(byte[] nodeIdentifier) {
        this.nodeIdentifierStrategy = new FixedNodeIdentifierStrategy(nodeIdentifier);
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withMacNodeIdentifier() {
        this.nodeIdentifierStrategy = new MacNodeIdentifierStrategy();
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withHashNodeIdentifier() {
        this.nodeIdentifierStrategy = new HashNodeIdentifierStrategy();
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withClockSequence(int clockSequence) {
        this.clockSequenceStrategy = new FixedClockSequenceStrategy(clockSequence);
        return (T)this;
    }

    public synchronized <T extends AbstractTimeBasedUuidCreator> T withClockSequence(byte[] clockSequence) {
        this.clockSequenceStrategy = new FixedClockSequenceStrategy(clockSequence);
        return (T)this;
    }

    protected long formatMostSignificantBits(long timestamp) {
        return (timestamp & 0xFFF000000000000L) >>> 48 | (timestamp & 0xFFFF00000000L) >>> 16 | (timestamp & 0xFFFFFFFFL) << 32 | 0x1000L;
    }

    protected long formatLeastSignificantBits(long nodeIdentifier, long clockSequence) {
        return (clockSequence << 48 | nodeIdentifier & 0xFFFFFFFFFFFFL) & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected static NodeIdentifierStrategy selectNodeIdentifierStrategy() {
        String string = UuidCreatorSettings.getProperty("node");
        if (NODE_MAC.equalsIgnoreCase(string)) {
            return new MacNodeIdentifierStrategy();
        }
        if (NODE_HASH.equalsIgnoreCase(string)) {
            return new HashNodeIdentifierStrategy();
        }
        Long number = UuidCreatorSettings.getNodeIdentifier();
        if (number != null) {
            return new FixedNodeIdentifierStrategy(number);
        }
        return new DefaultNodeIdentifierStrategy();
    }
}

