/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.util.UuidUtil;
import com.github.f4b6a3.uuid.util.internal.ByteUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.UUID;

public final class MachineId {
    private MachineId() {
    }

    public static long getMachineId() {
        byte[] bytes = MachineId.getMachineHash();
        return ByteUtil.toNumber(bytes, 0, 8);
    }

    public static UUID getMachineUuid() {
        byte[] bytes = MachineId.getMachineHash();
        long msb = ByteUtil.toNumber(bytes, 0, 8);
        long lsb = ByteUtil.toNumber(bytes, 8, 16);
        UUID uuid = new UUID(msb, lsb);
        return UuidUtil.applyVersion(uuid, 4);
    }

    public static String getMachineHexa() {
        byte[] bytes = MachineId.getMachineHash();
        return ByteUtil.toHexadecimal(bytes);
    }

    public static byte[] getMachineHash() {
        String string = MachineId.getMachineString();
        return MessageDigestHolder.digest(string);
    }

    public static String getMachineString() {
        String hostName = null;
        String nicMac = null;
        String nicAddr = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                if (nic == null || nic.isLoopback()) continue;
                byte[] mac = nic.getHardwareAddress();
                Enumeration<InetAddress> ips = nic.getInetAddresses();
                if (mac == null || mac.length != 6 || !ips.hasMoreElements()) continue;
                nicMac = MachineId.formatMac(mac);
                ArrayList<String> list = new ArrayList<String>();
                while (ips.hasMoreElements()) {
                    InetAddress ip = ips.nextElement();
                    list.add(ip.getHostAddress());
                }
                nicAddr = String.join((CharSequence)" ", list);
                break;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return String.join((CharSequence)" ", hostName, nicMac, nicAddr);
    }

    private static String formatMac(byte[] mac) {
        CharSequence[] hex = new String[mac.length];
        for (int i = 0; i < mac.length; ++i) {
            hex[i] = String.format("%02X", mac[i]);
        }
        return String.join((CharSequence)"-", hex);
    }

    private static class MessageDigestHolder {
        static final MessageDigest INSTANCE = MessageDigestHolder.getMessageDigest();

        private MessageDigestHolder() {
        }

        static synchronized byte[] digest(String string) {
            return INSTANCE.digest(string.getBytes());
        }

        private static MessageDigest getMessageDigest() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InternalError("Message digest algorithm not supported.", e);
            }
        }
    }
}

