/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator;

import com.github.f4b6a3.uuid.creator.AbstractUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidNamespace;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.util.UuidConverter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public abstract class AbstractNameBasedUuidCreator
extends AbstractUuidCreator {
    protected byte[] namespace = null;
    protected final String algorithm;
    protected static final String MESSAGE_DIGEST_MD5 = "MD5";
    protected static final String MESSAGE_DIGEST_SHA1 = "SHA-1";

    public AbstractNameBasedUuidCreator(UuidVersion version, String algorithm) {
        super(version);
        this.algorithm = algorithm;
    }

    public UUID create(byte[] name) {
        return this.create(this.namespace, name);
    }

    public UUID create(String name) {
        return this.create(this.namespace, name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(UUID namespace, byte[] name) {
        return this.create(UuidConverter.toBytes(namespace), name);
    }

    public UUID create(UUID namespace, String name) {
        return this.create(UuidConverter.toBytes(namespace), name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(String namespace, byte[] name) {
        return this.create(UuidConverter.fromString(namespace), name);
    }

    public UUID create(String namespace, String name) {
        return this.create(UuidConverter.fromString(namespace), name.getBytes(StandardCharsets.UTF_8));
    }

    public UUID create(UuidNamespace namespace, byte[] name) {
        return this.create(namespace.getValue(), name);
    }

    public UUID create(UuidNamespace namespace, String name) {
        return this.create(namespace.getValue(), name.getBytes(StandardCharsets.UTF_8));
    }

    private UUID create(byte[] namespace, byte[] name) {
        MessageDigest hasher;
        try {
            hasher = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Message digest algorithm not available", e);
        }
        if (namespace != null) {
            hasher.update(namespace);
        }
        byte[] hash = hasher.digest(name);
        return this.getUuid(hash);
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UUID namespace) {
        this.namespace = UuidConverter.toBytes(namespace);
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(String namespace) {
        this.namespace = UuidConverter.toBytes(UuidConverter.fromString(namespace));
        return (T)this;
    }

    public synchronized <T extends AbstractNameBasedUuidCreator> T withNamespace(UuidNamespace namespace) {
        this.namespace = UuidConverter.toBytes(namespace.getValue());
        return (T)this;
    }
}

