/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.creator.rfc4122;

import com.github.f4b6a3.uuid.creator.AbstractTimeBasedUuidCreator;
import com.github.f4b6a3.uuid.enums.UuidLocalDomain;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public final class DceSecurityUuidCreator
extends AbstractTimeBasedUuidCreator {
    private AtomicInteger counter = new AtomicInteger();
    private byte localDomain;

    public DceSecurityUuidCreator() {
        super(UuidVersion.VERSION_DCE_SECURITY);
    }

    public synchronized UUID create(byte localDomain, int localIdentifier) {
        UUID uuid = super.create();
        long msb = DceSecurityUuidCreator.setLocalIdentifierBits(uuid.getMostSignificantBits(), localIdentifier);
        long lsb = DceSecurityUuidCreator.setLocalDomainBits(uuid.getLeastSignificantBits(), localDomain, this.counter.incrementAndGet());
        return new UUID(this.applyVersionBits(msb), this.applyVariantBits(lsb));
    }

    public synchronized UUID create(UuidLocalDomain localDomain, int localIdentifier) {
        if (localDomain == null) {
            throw new UuidCreatorException("Null local domain");
        }
        return this.create(localDomain.getValue(), localIdentifier);
    }

    public synchronized UUID create(int localIdentifier) {
        return this.create(this.localDomain, localIdentifier);
    }

    @Override
    public synchronized UUID create() {
        throw new UnsupportedOperationException("Unsuported operation for DCE Security UUID creator");
    }

    @Override
    public UUID create(Instant instant, Integer clockseq, Long nodeid) {
        throw new UnsupportedOperationException("Unsuported operation for DCE Security UUID creator");
    }

    private static long setLocalIdentifierBits(long msb, int localIdentifier) {
        return msb & 0xFFFFFFFFL | ((long)localIdentifier & 0xFFFFFFFFL) << 32;
    }

    private static long setLocalDomainBits(long lsb, byte localDomain, long counter) {
        return lsb & 0xFFFFFFFFFFFFL | ((long)localDomain & 0xFFL) << 48 | (counter & 0xFFL) << 56;
    }

    public synchronized DceSecurityUuidCreator withLocalDomain(UuidLocalDomain localDomain) {
        this.localDomain = localDomain.getValue();
        return this;
    }

    public synchronized DceSecurityUuidCreator withLocalDomain(byte localDomain) {
        this.localDomain = localDomain;
        return this;
    }
}

