/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.clockseq;

import com.github.f4b6a3.uuid.strategy.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.strategy.clockseq.ClockSequenceController;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.sequence.AbstractSequence;

public final class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long previousTimestamp = 0L;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;
    public static final ClockSequenceController CONTROLLER = new ClockSequenceController();

    public DefaultClockSequenceStrategy() {
        super(0, 16383);
        this.value = -1;
        this.reset();
    }

    @Override
    public int getClockSequence(long timestamp) {
        if (timestamp > this.previousTimestamp) {
            this.previousTimestamp = timestamp;
            return this.current();
        }
        this.previousTimestamp = timestamp;
        return this.next();
    }

    @Override
    public int next() {
        int give = this.current();
        int take = super.next();
        this.value = CONTROLLER.borrow(give, take);
        return this.value;
    }

    @Override
    public void reset() {
        int give = this.current();
        int take = RandomUtil.get().nextInt() & 0x3FFF;
        this.value = CONTROLLER.borrow(give, take);
    }
}

