/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

public class ByteUtil {
    private ByteUtil() {
    }

    public static long toNumber(String hexadecimal) {
        return ByteUtil.toNumber(ByteUtil.toBytes(hexadecimal));
    }

    public static long toNumber(char[] hexadecimal) {
        return ByteUtil.toNumber(ByteUtil.toBytes(hexadecimal));
    }

    public static long toNumber(byte[] bytes) {
        return ByteUtil.toNumber(bytes, 0, bytes.length);
    }

    public static long toNumber(byte[] bytes, int start, int length) {
        long result = 0L;
        for (int i = start; i < length; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    public static byte[] toBytes(long number) {
        return new byte[]{(byte)(number >>> 56), (byte)(number >>> 48), (byte)(number >>> 40), (byte)(number >>> 32), (byte)(number >>> 24), (byte)(number >>> 16), (byte)(number >>> 8), (byte)number};
    }

    public static byte[] toBytes(long ... numbers) {
        byte[] bytes = new byte[numbers.length * 8];
        int i = 0;
        int j = 0;
        while (i < numbers.length) {
            System.arraycopy(ByteUtil.toBytes(numbers[i]), 0, bytes, j, 8);
            ++i;
            j += 8;
        }
        return bytes;
    }

    public static byte[] toBytes(String hexadecimal) {
        return ByteUtil.toBytes(hexadecimal.toCharArray());
    }

    public static byte[] toBytes(char[] hexadecimal) {
        byte[] bytes = new byte[hexadecimal.length / 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            bytes[i] = (byte)(ByteUtil.fromHexChar(hexadecimal[j]) << 4 | ByteUtil.fromHexChar(hexadecimal[j + 1]));
            ++i;
            j += 2;
        }
        return bytes;
    }

    public static String toHexadecimal(byte[] bytes) {
        return new String(ByteUtil.toHexadecimalChars(bytes));
    }

    public static char[] toHexadecimalChars(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int i = 0;
        int j = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            chars[j] = ByteUtil.toHexChar(v >>> 4);
            chars[j + 1] = ByteUtil.toHexChar(v & 0xF);
            ++i;
            j += 2;
        }
        return chars;
    }

    public static char[] toHexadecimalChars(long ... numbers) {
        return ByteUtil.toHexadecimalChars(ByteUtil.toBytes(numbers));
    }

    public static String toHexadecimal(long ... numbers) {
        return new String(ByteUtil.toHexadecimalChars(ByteUtil.toBytes(numbers)));
    }

    public static String toHexadecimal(long number) {
        return new String(ByteUtil.toHexadecimalChars(number));
    }

    private static int fromHexChar(char chr) {
        char c = chr;
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        return 0;
    }

    private static char toHexChar(int number) {
        if (number >= 0 && number <= 9) {
            return (char)(48 + number);
        }
        if (number >= 10 && number <= 15) {
            return (char)(87 + number);
        }
        return '\u0000';
    }

    public static byte[] array(int length, byte value) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = value;
        }
        return result;
    }

    public static byte[] copy(byte[] bytes) {
        return ByteUtil.copy(bytes, 0, bytes.length);
    }

    public static byte[] copy(byte[] bytes, int start, int end) {
        int length = end - start;
        byte[] result = new byte[length];
        System.arraycopy(bytes, start, result, 0, length);
        return result;
    }

    public static byte[] concat(byte[] bytes1, byte[] bytes2) {
        byte[] result = new byte[bytes1.length + bytes2.length];
        System.arraycopy(bytes1, 0, result, 0, bytes1.length);
        System.arraycopy(bytes2, 0, result, bytes1.length, bytes2.length);
        return result;
    }

    public static boolean equalArrays(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

