/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.util;

import com.github.f4b6a3.uuid.enums.UuidVariant;
import com.github.f4b6a3.uuid.enums.UuidVersion;
import com.github.f4b6a3.uuid.exception.IllegalUuidException;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.UuidTimeUtil;
import java.time.Instant;
import java.util.UUID;

public class UuidUtil {
    private UuidUtil() {
    }

    public static UuidVersion getVersion(UUID uuid) {
        return UuidVersion.getVersion(uuid.version());
    }

    public static UuidVariant getVariant(UUID uuid) {
        return UuidVariant.getVariant(uuid.variant());
    }

    public static boolean isNil(UUID uuid) {
        if (uuid == null) {
            throw new InvalidUuidException("Null UUID is not comparable to Nil UUID");
        }
        return uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L;
    }

    public static boolean isRfc4122(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RFC_4122);
    }

    public static boolean isReservedNcs(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_NCS);
    }

    public static boolean isReservedMicrosoft(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_MICROSOFT);
    }

    public static boolean isReservedFuture(UUID uuid) {
        return UuidUtil.isVariant(uuid, UuidVariant.VARIANT_RESERVED_FUTURE);
    }

    public static boolean isRandomBased(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_RANDOM_BASED);
    }

    public static boolean isNameBasedMd5(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_NAME_BASED_MD5);
    }

    public static boolean isNameBasedSha1(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_NAMBE_BASED_SHA1);
    }

    public static boolean isTimeBased(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_TIME_BASED);
    }

    public static boolean isTimeOrdered(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_TIME_ORDERED);
    }

    public static boolean isDceSecurity(UUID uuid) {
        return UuidUtil.isVersion(uuid, UuidVersion.VERSION_DCE_SECURITY);
    }

    public static long extractNodeIdentifier(UUID uuid) {
        if (!(UuidUtil.isTimeBased(uuid) || UuidUtil.isTimeOrdered(uuid) || UuidUtil.isDceSecurity(uuid))) {
            throw new IllegalUuidException(String.format("Not a time-based, time-ordered or DCE Security UUID: %s.", uuid.toString()));
        }
        return uuid.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public static int extractClockSequence(UUID uuid) {
        if (!UuidUtil.isTimeBased(uuid) && !UuidUtil.isTimeOrdered(uuid) || UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalUuidException(String.format("Not a time-based, time-ordered or DCE Security UUID: %s.", uuid.toString()));
        }
        if (UuidUtil.isDceSecurity(uuid)) {
            return (int)(uuid.getLeastSignificantBits() >>> 56) & 0x3F;
        }
        return (int)(uuid.getLeastSignificantBits() >>> 48) & 0x3FFF;
    }

    public static Instant extractInstant(UUID uuid) {
        long timestamp = UuidUtil.extractTimestamp(uuid);
        return UuidTimeUtil.toInstant(timestamp);
    }

    public static long extractUnixMilliseconds(UUID uuid) {
        long timestamp = UuidUtil.extractTimestamp(uuid);
        return UuidTimeUtil.toUnixMilliseconds(timestamp);
    }

    public static long extractTimestamp(UUID uuid) {
        if (UuidUtil.isTimeBased(uuid)) {
            return UuidUtil.extractTimeBasedTimestamp(uuid.getMostSignificantBits());
        }
        if (UuidUtil.isTimeOrdered(uuid)) {
            return UuidUtil.extractTimeOrderedTimestamp(uuid.getMostSignificantBits());
        }
        if (UuidUtil.isDceSecurity(uuid)) {
            return UuidUtil.extractDceSecurityTimestamp(uuid.getMostSignificantBits());
        }
        throw new IllegalUuidException(String.format("Not a time-based, time-ordered or DCE Security UUID: %s.", uuid.toString()));
    }

    public static byte extractLocalDomain(UUID uuid) {
        if (!UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalUuidException(String.format("Not a DCE Security UUID: %s.", uuid.toString()));
        }
        return (byte)((uuid.getLeastSignificantBits() & 0xFF000000000000L) >>> 48);
    }

    public static int extractLocalIdentifier(UUID uuid) {
        if (!UuidUtil.isDceSecurity(uuid)) {
            throw new IllegalUuidException(String.format("Not a DCE Security UUID: %s.", uuid.toString()));
        }
        return (int)(uuid.getMostSignificantBits() >>> 32);
    }

    private static boolean isVariant(UUID uuid, UuidVariant variant) {
        if (uuid == null) {
            throw new InvalidUuidException("Null UUID has no variant");
        }
        return uuid.variant() == variant.getValue();
    }

    private static boolean isVersion(UUID uuid, UuidVersion version) {
        if (uuid == null) {
            throw new InvalidUuidException("Null UUID has no version");
        }
        return UuidUtil.isRfc4122(uuid) && uuid.version() == version.getValue();
    }

    private static long extractTimeBasedTimestamp(long msb) {
        long hii = (msb & 0xFFFFFFFF00000000L) >>> 32;
        long mid = (msb & 0xFFFF0000L) << 16;
        long low = (msb & 0xFFFL) << 48;
        return hii | mid | low;
    }

    private static long extractTimeOrderedTimestamp(long msb) {
        long himid = (msb & 0xFFFFFFFFFFFF0000L) >>> 4;
        long low = msb & 0xFFFL;
        return himid | low;
    }

    private static long extractDceSecurityTimestamp(long msb) {
        return UuidUtil.extractTimeBasedTimestamp(msb & 0xFFFFFFFFL);
    }
}

