/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.strategy.timestamp;

import com.github.f4b6a3.commons.util.RandomUtil;
import com.github.f4b6a3.uuid.exception.UuidCreatorException;
import com.github.f4b6a3.uuid.strategy.TimestampStrategy;
import com.github.f4b6a3.uuid.util.UuidTimeUtil;
import com.github.f4b6a3.uuid.util.sequence.AbstractSequence;

public class DefaultTimestampStrategy
extends AbstractSequence
implements TimestampStrategy {
    protected long previousTimestamp = 0L;
    protected boolean enableOverrunException = true;
    protected static final int COUNTER_MIN = 0;
    protected static final int COUNTER_MAX = 9999;
    protected static final int COUNTER_OFFSET_MAX = 255;
    protected static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many UUIDs.";

    public DefaultTimestampStrategy() {
        this(true);
    }

    public DefaultTimestampStrategy(boolean enableOverrunException) {
        super(0, 9999);
        this.enableOverrunException = enableOverrunException;
        this.value = RandomUtil.get().nextInt(255);
    }

    @Override
    public long getTimestamp() {
        long timestamp = UuidTimeUtil.getCurrentTimestamp();
        long counter = this.getNextCounter(timestamp);
        return timestamp + counter;
    }

    protected long getNextCounter(long timestamp) {
        if (timestamp > this.previousTimestamp) {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return this.next();
    }

    @Override
    public int next() {
        if (this.value > this.maxValue) {
            this.value = this.minValue;
            if (this.enableOverrunException) {
                throw new UuidCreatorException(OVERRUN_MESSAGE);
            }
        }
        return this.value++;
    }

    @Override
    public void reset() {
        this.value &= 0xFF;
    }
}

