/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import com.github.f4b6a3.uuid.enums.UuidVersion;

public abstract class AbstractUuidCreator {
    protected final int version;
    protected final long versionBits;

    protected AbstractUuidCreator() {
        this.version = 0;
        this.versionBits = 0L;
    }

    public AbstractUuidCreator(int version) {
        this.version = version & 0xF;
        this.versionBits = version << 12;
    }

    public AbstractUuidCreator(UuidVersion version) {
        this(version.getValue());
    }

    public int getVersion() {
        return this.version;
    }

    protected long getVariantBits(long lsb) {
        return lsb & 0xC000000000000000L;
    }

    protected long setVariantBits(long lsb) {
        return lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected long getVersionBits(long msb) {
        return msb & 0xF000L;
    }

    protected long setVersionBits(long msb) {
        return msb & 0xFFFFFFFFFFFF0FFFL | this.versionBits;
    }
}

