/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.sequence;

import com.github.f4b6a3.uuid.sequence.Sequence;

public abstract class AbstractSequence
implements Sequence {
    protected int value;
    public final int minValue;
    public final int maxValue;

    protected AbstractSequence(int min, int max) {
        this.minValue = min;
        this.maxValue = max;
        this.value = this.minValue;
    }

    @Override
    public int current() {
        return this.value;
    }

    @Override
    public int next() {
        if (this.value >= this.maxValue) {
            this.value = this.minValue;
            return this.value;
        }
        return ++this.value;
    }

    @Override
    public int min() {
        return this.minValue;
    }

    @Override
    public int max() {
        return this.maxValue;
    }

    @Override
    public void reset() {
        this.value = this.minValue;
    }

    @Override
    public void set(int value) {
        if (value < this.minValue || value > this.maxValue) {
            this.reset();
        }
        this.value = value;
    }
}

