/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.timestamp;

import com.github.f4b6a3.uuid.timestamp.TimestampStrategy;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;

public class NanosecondTimestampStrategy
implements TimestampStrategy {
    public static final long NANOSECONDS_PER_SECOND = 1000000000L;
    public static final long TIMESTAMP_RESOLUTION = 100L;
    public static final long GREGORIAN_SECONDS = LocalDate.parse("1582-10-15").atStartOfDay(ZoneId.of("UTC")).toInstant().getEpochSecond();

    @Override
    public long getTimestamp() {
        Instant instant = Instant.now();
        long seconds = (instant.getEpochSecond() - GREGORIAN_SECONDS) * 10000000L;
        long milliseconds = (long)instant.getNano() / 100L;
        return seconds + milliseconds;
    }
}

