/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.clockseq;

import com.github.f4b6a3.uuid.clockseq.ClockSequenceStrategy;
import com.github.f4b6a3.uuid.exception.OverrunException;
import com.github.f4b6a3.uuid.sequence.AbstractSequence;
import com.github.f4b6a3.uuid.state.AbstractUuidState;
import com.github.f4b6a3.uuid.state.FileUuidState;
import com.github.f4b6a3.uuid.util.RandomUtil;
import com.github.f4b6a3.uuid.util.SettingsUtil;

public class DefaultClockSequenceStrategy
extends AbstractSequence
implements ClockSequenceStrategy {
    private long timestamp = 0L;
    private long nodeIdentifier = 0L;
    private int counter = 0;
    protected AbstractUuidState state;
    protected static final int SEQUENCE_MIN = 0;
    protected static final int SEQUENCE_MAX = 16383;

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier, AbstractUuidState state) {
        super(0, 16383);
        this.timestamp = timestamp;
        this.nodeIdentifier = nodeIdentifier;
        int defaultClockSequence = SettingsUtil.getClockSequence();
        if (SettingsUtil.isStateEnabled()) {
            this.state = state == null ? new FileUuidState() : state;
            long lastTimestamp = this.state.getTimestamp();
            long lastNodeIdentifier = this.state.getNodeIdentifier();
            int lastClockSequence = this.state.getClockSequence();
            if (lastClockSequence != 0) {
                this.set(lastClockSequence);
                if (this.timestamp <= lastTimestamp || this.nodeIdentifier != lastNodeIdentifier) {
                    this.next();
                }
            } else if (defaultClockSequence != 0) {
                this.set(defaultClockSequence);
            } else {
                this.reset();
            }
            Runtime.getRuntime().addShutdownHook(new DefaultClockSequenceShutdownHook(this));
        } else if (defaultClockSequence != 0) {
            this.set(defaultClockSequence);
        } else {
            this.reset();
        }
    }

    public DefaultClockSequenceStrategy(long timestamp, long nodeIdentifier) {
        this(timestamp, nodeIdentifier, null);
    }

    public DefaultClockSequenceStrategy() {
        this(0L, 0L, null);
    }

    @Override
    public int getClockSequence(long timestamp, long nodeIdentifier) {
        if (timestamp <= this.timestamp) {
            if (this.counter >= 16383) {
                throw new OverrunException("Too many requests.");
            }
            ++this.counter;
            this.timestamp = timestamp;
            return this.next();
        }
        this.counter = 0;
        this.timestamp = timestamp;
        return this.current();
    }

    @Override
    public void reset() {
        this.value = RandomUtil.nextInt(16383);
    }

    protected void storeState() {
        if (SettingsUtil.isStateEnabled()) {
            this.state.setNodeIdentifier(this.nodeIdentifier);
            this.state.setTimestamp(this.timestamp);
            this.state.setClockSequence(this.value);
            this.state.store();
        }
    }

    protected static class DefaultClockSequenceShutdownHook
    extends Thread {
        private DefaultClockSequenceStrategy strategy;

        public DefaultClockSequenceShutdownHook(DefaultClockSequenceStrategy strategy) {
            this.strategy = strategy;
        }

        @Override
        public void run() {
            this.strategy.storeState();
        }
    }
}

