/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.factory.abst;

import java.util.UUID;

public abstract class AbstractUuidCreator {
    protected final int version;
    public static final int VARIANT_RESERVED_NCS = 0;
    public static final int VARIANT_RFC4122 = 2;
    public static final int VARIANT_RESERVED_MICROSOFT = 6;
    public static final int VARIANT_RESERVED_FUTURE = 7;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final UUID NIL_UUID = new UUID(0L, 0L);
    public static final UUID NAMESPACE_DNS = new UUID(7757371264673321425L, -9172705715073830712L);
    public static final UUID NAMESPACE_URL = new UUID(7757371268968288721L, -9172705715073830712L);
    public static final UUID NAMESPACE_OID = new UUID(7757371273263256017L, -9172705715073830712L);
    public static final UUID NAMESPACE_X500 = new UUID(7757371281853190609L, -9172705715073830712L);
    public static final long RFC4122_VARIANT_BITS = Long.MIN_VALUE;
    public static final long[] RFC4122_VERSION_BITS = new long[]{0L, 4096L, 8192L, 12288L, 16384L, 20480L};

    public AbstractUuidCreator(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean valid(long msb, long lsb) {
        long variantBits = this.getVariantBits(lsb);
        long versionBits = this.getVersionBits(msb);
        return variantBits == Long.MIN_VALUE && versionBits == RFC4122_VERSION_BITS[this.version];
    }

    protected long getVariantBits(long lsb) {
        return lsb & 0xC000000000000000L;
    }

    protected long setVariantBits(long lsb) {
        return lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
    }

    protected long getVersionBits(long msb) {
        return msb & 0xF000L;
    }

    protected long setVersionBits(long msb) {
        return msb & 0xFFFFFFFFFFFF0FFFL | RFC4122_VERSION_BITS[this.version];
    }
}

