/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid;

import com.github.f4b6a3.ulid.Ulid;
import java.security.SecureRandom;
import java.time.Clock;
import java.util.Random;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public final class UlidFactory {
    private final Clock clock;
    private final LongFunction<Ulid> ulidFunction;

    public UlidFactory() {
        this(new UlidFunction(), null);
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction) {
        this(ulidFunction, null);
    }

    private UlidFactory(LongFunction<Ulid> ulidFunction, Clock clock) {
        this.ulidFunction = ulidFunction;
        this.clock = clock != null ? clock : Clock.systemUTC();
    }

    public static UlidFactory newInstance() {
        return new UlidFactory(new UlidFunction());
    }

    public static UlidFactory newInstance(Random random) {
        return new UlidFactory(new UlidFunction(random));
    }

    public static UlidFactory newInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new UlidFunction(randomSupplier));
    }

    protected static UlidFactory newInstance(Supplier<byte[]> randomSupplier, Clock clock) {
        return new UlidFactory(new UlidFunction(randomSupplier), clock);
    }

    public static UlidFactory newMonotonicInstance() {
        return new UlidFactory(new MonotonicFunction());
    }

    public static UlidFactory newMonotonicInstance(Random random) {
        return new UlidFactory(new MonotonicFunction(random));
    }

    public static UlidFactory newMonotonicInstance(Supplier<byte[]> randomSupplier) {
        return new UlidFactory(new MonotonicFunction(randomSupplier));
    }

    protected static UlidFactory newMonotonicInstance(Supplier<byte[]> randomSupplier, Clock clock) {
        return new UlidFactory(new MonotonicFunction(randomSupplier), clock);
    }

    public Ulid create() {
        return this.create(this.clock.millis());
    }

    public Ulid create(long time) {
        return this.ulidFunction.apply(time);
    }

    protected static Supplier<byte[]> getRandomSupplier(Random random) {
        return () -> {
            byte[] payload = new byte[10];
            random.nextBytes(payload);
            return payload;
        };
    }

    protected static final class MonotonicFunction
    implements LongFunction<Ulid> {
        private long lastTime = 0L;
        private Ulid lastUlid = null;
        protected static final int CLOCK_DRIFT_TOLERANCE = 10000;
        private Supplier<byte[]> randomSupplier;

        public MonotonicFunction() {
            this(new SecureRandom());
        }

        public MonotonicFunction(Random random) {
            this(UlidFactory.getRandomSupplier(random));
        }

        public MonotonicFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public synchronized Ulid apply(long time) {
            this.lastUlid = time > this.lastTime - 10000L && time <= this.lastTime ? this.lastUlid.increment() : new Ulid(time, this.randomSupplier.get());
            this.lastTime = this.lastUlid.getTime();
            return new Ulid(this.lastUlid);
        }
    }

    protected static final class UlidFunction
    implements LongFunction<Ulid> {
        private Supplier<byte[]> randomSupplier;

        public UlidFunction() {
            this(new SecureRandom());
        }

        public UlidFunction(Random random) {
            this(UlidFactory.getRandomSupplier(random));
        }

        public UlidFunction(Supplier<byte[]> randomSupplier) {
            this.randomSupplier = randomSupplier;
        }

        @Override
        public Ulid apply(long time) {
            return new Ulid(time, this.randomSupplier.get());
        }
    }
}

