/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.UlidValidator;
import java.time.Instant;
import java.util.UUID;

public final class UlidUtil {
    protected static final int BASE_32 = 32;
    protected static final int ULID_LENGTH = 26;
    protected static final char[] ALPHABET_CROCKFORD = "0123456789ABCDEFGHJKMNPQRSTVWXYZOIL".toCharArray();
    protected static final char[] ALPHABET_JAVA = "0123456789abcdefghijklmnopqrstuv011".toCharArray();

    private UlidUtil() {
    }

    public static long extractUnixMilliseconds(UUID ulid) {
        return UlidUtil.extractTimestamp(ulid);
    }

    public static long extractUnixMilliseconds(String ulid) {
        UlidValidator.validate(ulid);
        return UlidUtil.extractTimestamp(ulid);
    }

    public static Instant extractInstant(UUID ulid) {
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    public static Instant extractInstant(String ulid) {
        UlidValidator.validate(ulid);
        long milliseconds = UlidUtil.extractTimestamp(ulid);
        return Instant.ofEpochMilli(milliseconds);
    }

    private static long extractTimestamp(UUID ulid) {
        return ulid.getMostSignificantBits() >>> 16;
    }

    private static long extractTimestamp(String ulid) {
        return UlidUtil.fromBase32Crockford(UlidUtil.extractTimestampComponent(ulid).toCharArray());
    }

    public static String extractTimestampComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(0, 10);
    }

    public static String extractRandomnessComponent(String ulid) {
        UlidValidator.validate(ulid);
        return ulid.substring(10, 26);
    }

    public static long toNumber(byte[] bytes) {
        return UlidUtil.toNumber(bytes, 0, bytes.length);
    }

    public static long toNumber(byte[] bytes, int start, int end) {
        long result = 0L;
        for (int i = start; i < end; ++i) {
            result = result << 8 | (long)(bytes[i] & 0xFF);
        }
        return result;
    }

    protected static byte[] toBytes(long number) {
        return new byte[]{(byte)(number >>> 56), (byte)(number >>> 48), (byte)(number >>> 40), (byte)(number >>> 32), (byte)(number >>> 24), (byte)(number >>> 16), (byte)(number >>> 8), (byte)number};
    }

    protected static char[] removeHyphens(char[] input) {
        int count = 0;
        char[] buffer = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == '-') continue;
            buffer[count++] = input[i];
        }
        char[] output = new char[count];
        System.arraycopy(buffer, 0, output, 0, count);
        return output;
    }

    public static char[] toBase32Crockford(long number) {
        return UlidUtil.encode(number, ALPHABET_CROCKFORD);
    }

    public static long fromBase32Crockford(char[] chars) {
        return UlidUtil.decode(chars, ALPHABET_CROCKFORD);
    }

    protected static boolean isCrockfordBase32(char[] chars) {
        char[] input = UlidUtil.toUpperCase(chars);
        for (int i = 0; i < input.length; ++i) {
            if (UlidUtil.isCrockfordBase32(input[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean isCrockfordBase32(char c) {
        for (int j = 0; j < ALPHABET_CROCKFORD.length; ++j) {
            if (c != ALPHABET_CROCKFORD[j]) continue;
            return true;
        }
        return false;
    }

    protected static char[] zerofill(char[] chars, int length) {
        return UlidUtil.lpad(chars, length, '0');
    }

    protected static char[] lpad(char[] chars, int length, char fill) {
        int delta = 0;
        int limit = 0;
        if (length > chars.length) {
            delta = length - chars.length;
            limit = length;
        } else {
            delta = 0;
            limit = chars.length;
        }
        char[] output = new char[chars.length + delta];
        for (int i = 0; i < limit; ++i) {
            output[i] = i < delta ? fill : chars[i - delta];
        }
        return output;
    }

    protected static String transliterate(String string, char[] alphabet1, char[] alphabet2) {
        return new String(UlidUtil.transliterate(string.toCharArray(), alphabet1, alphabet2));
    }

    protected static char[] transliterate(char[] chars, char[] alphabet1, char[] alphabet2) {
        char[] output = (char[])chars.clone();
        block0: for (int i = 0; i < output.length; ++i) {
            for (int j = 0; j < alphabet1.length; ++j) {
                if (output[i] != alphabet1[j]) continue;
                output[i] = alphabet2[j];
                continue block0;
            }
        }
        return output;
    }

    protected static char[] toUpperCase(char[] chars) {
        char[] output = new char[chars.length];
        for (int i = 0; i < output.length; ++i) {
            output[i] = chars[i] >= 'a' && chars[i] <= 'z' ? (char)(chars[i] & 0xFFFFFFDF) : chars[i];
        }
        return output;
    }

    protected static char[] encode(long number, char[] alphabet) {
        int CHARS_MAX = 13;
        if (number < 0L) {
            throw new IllegalArgumentException(String.format("Number '%d' is not a positive integer.", number));
        }
        char[] buffer = new char[13];
        int count = 13;
        for (long n = number; n > 0L; n /= 32L) {
            buffer[--count] = alphabet[(int)(n % 32L)];
        }
        char[] output = new char[buffer.length - count];
        System.arraycopy(buffer, count, output, 0, output.length);
        return output;
    }

    protected static long decode(char[] chars, char[] alphabet) {
        long n = 0L;
        for (int i = 0; i < chars.length; ++i) {
            int d = UlidUtil.chr(chars[i], alphabet);
            n = 32L * n + (long)d;
        }
        return n;
    }

    private static int chr(char c, char[] alphabet) {
        for (int i = 0; i < alphabet.length; ++i) {
            if (alphabet[i] != c) continue;
            return (byte)i;
        }
        return 48;
    }
}

