/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.creator;

import com.github.f4b6a3.ulid.strategy.RandomStrategy;
import com.github.f4b6a3.ulid.strategy.TimestampStrategy;
import com.github.f4b6a3.ulid.strategy.random.DefaultRandomStrategy;
import com.github.f4b6a3.ulid.strategy.random.OtherRandomStrategy;
import com.github.f4b6a3.ulid.strategy.timestamp.DefaultTimestampStrategy;
import com.github.f4b6a3.ulid.util.UlidUtil;
import com.github.f4b6a3.ulid.util.internal.UlidStruct;
import java.util.Random;
import java.util.UUID;

public class UlidSpecCreator {
    protected long random1 = 0L;
    protected long random2 = 0L;
    protected long randomMax1;
    protected long randomMax2;
    protected static final long HALF_RANDOM_COMPONENT = 0xFFFFFFFFFFL;
    protected static final long INCREMENT_MAX = 0x10000000000L;
    protected long previousTimestamp;
    protected static final String OVERRUN_MESSAGE = "The system overran the generator by requesting too many ULIDs.";
    protected TimestampStrategy timestampStrategy = new DefaultTimestampStrategy();
    protected RandomStrategy randomStrategy = new DefaultRandomStrategy();

    public synchronized UUID create() {
        UlidStruct struct = new UlidStruct(this.getTimestamp(), this.random1, this.random2);
        return struct.toUuid();
    }

    public synchronized UUID create4() {
        return UlidSpecCreator.applyVersion4(this.create());
    }

    public synchronized String createString() {
        UlidStruct struct = new UlidStruct(this.getTimestamp(), this.random1, this.random2);
        return struct.toString();
    }

    public synchronized String createString4() {
        UUID uuid = UlidSpecCreator.applyVersion4(this.create());
        UlidStruct struct = new UlidStruct(uuid);
        return struct.toString();
    }

    protected synchronized long getTimestamp() {
        long timestamp = this.timestampStrategy.getTimestamp();
        if (timestamp == this.previousTimestamp) {
            this.increment();
        } else {
            this.reset();
        }
        this.previousTimestamp = timestamp;
        return timestamp;
    }

    protected synchronized void reset() {
        byte[] bytes = new byte[10];
        this.randomStrategy.nextBytes(bytes);
        this.random1 = UlidUtil.toNumber(bytes, 0, 5);
        this.random2 = UlidUtil.toNumber(bytes, 5, 10);
        this.randomMax1 = this.random1 | 0x10000000000L;
        this.randomMax2 = this.random2 | 0x10000000000L;
    }

    protected synchronized void increment() {
        if (++this.random2 >= this.randomMax2) {
            this.random2 &= 0xFFFFFFFFFFL;
            if (++this.random1 >= this.randomMax1) {
                this.reset();
            }
        }
    }

    public synchronized <T extends UlidSpecCreator> T withTimestampStrategy(TimestampStrategy timestampStrategy) {
        this.timestampStrategy = timestampStrategy;
        return (T)this;
    }

    public synchronized <T extends UlidSpecCreator> T withRandomStrategy(RandomStrategy randomStrategy) {
        this.randomStrategy = randomStrategy;
        return (T)this;
    }

    public synchronized <T extends UlidSpecCreator> T withRandomGenerator(Random random) {
        this.randomStrategy = new OtherRandomStrategy(random);
        return (T)this;
    }

    protected long extractRandom1(UUID uuid) {
        return (uuid.getMostSignificantBits() & 0xFFFFL) << 24 | uuid.getLeastSignificantBits() >>> 40;
    }

    protected long extractRandom2(UUID uuid) {
        return uuid.getLeastSignificantBits() & 0xFFFFFFFFFFL;
    }

    private static UUID applyVersion4(UUID ulid) {
        long msb = ulid.getMostSignificantBits() & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        long lsb = ulid.getLeastSignificantBits() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }
}

