/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util.internal;

import com.github.f4b6a3.ulid.util.UlidValidator;
import java.util.UUID;

public final class UlidStruct {
    public final long time;
    public final long random1;
    public final long random2;
    protected static final long TIMESTAMP_COMPONENT = 0xFFFFFFFFFFFFL;
    protected static final long HALF_RANDOM_COMPONENT = 0xFFFFFFFFFFL;
    public static final char[] BASE32_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    public static final long[] BASE32_VALUES = new long[128];

    public UlidStruct(long time, long random1, long random2) {
        this.time = time & 0xFFFFFFFFFFFFL;
        this.random1 = random1 & 0xFFFFFFFFFFL;
        this.random2 = random2 & 0xFFFFFFFFFFL;
    }

    public UlidStruct(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        this.time = msb >>> 16;
        this.random1 = (msb & 0xFFFFL) << 24 | lsb >>> 40;
        this.random2 = lsb & 0xFFFFFFFFFFL;
    }

    public UlidStruct(String string) {
        UlidValidator.validate(string);
        long tm = 0L;
        long r1 = 0L;
        long r2 = 0L;
        char[] chars = string.toCharArray();
        tm |= BASE32_VALUES[chars[0]] << 45;
        tm |= BASE32_VALUES[chars[1]] << 40;
        tm |= BASE32_VALUES[chars[2]] << 35;
        tm |= BASE32_VALUES[chars[3]] << 30;
        tm |= BASE32_VALUES[chars[4]] << 25;
        tm |= BASE32_VALUES[chars[5]] << 20;
        tm |= BASE32_VALUES[chars[6]] << 15;
        tm |= BASE32_VALUES[chars[7]] << 10;
        tm |= BASE32_VALUES[chars[8]] << 5;
        tm |= BASE32_VALUES[chars[9]];
        r1 |= BASE32_VALUES[chars[10]] << 35;
        r1 |= BASE32_VALUES[chars[11]] << 30;
        r1 |= BASE32_VALUES[chars[12]] << 25;
        r1 |= BASE32_VALUES[chars[13]] << 20;
        r1 |= BASE32_VALUES[chars[14]] << 15;
        r1 |= BASE32_VALUES[chars[15]] << 10;
        r1 |= BASE32_VALUES[chars[16]] << 5;
        r1 |= BASE32_VALUES[chars[17]];
        r2 |= BASE32_VALUES[chars[18]] << 35;
        r2 |= BASE32_VALUES[chars[19]] << 30;
        r2 |= BASE32_VALUES[chars[20]] << 25;
        r2 |= BASE32_VALUES[chars[21]] << 20;
        r2 |= BASE32_VALUES[chars[22]] << 15;
        r2 |= BASE32_VALUES[chars[23]] << 10;
        r2 |= BASE32_VALUES[chars[24]] << 5;
        this.time = tm;
        this.random1 = r1;
        this.random2 = r2 |= BASE32_VALUES[chars[25]];
    }

    public String toString() {
        char[] chars = new char[]{BASE32_CHARS[(int)(this.time >>> 45 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 40 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 35 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 30 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 25 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 20 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 15 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 10 & 0x1FL)], BASE32_CHARS[(int)(this.time >>> 5 & 0x1FL)], BASE32_CHARS[(int)(this.time & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 35 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 30 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 25 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 20 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 15 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 10 & 0x1FL)], BASE32_CHARS[(int)(this.random1 >>> 5 & 0x1FL)], BASE32_CHARS[(int)(this.random1 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 35 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 30 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 25 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 20 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 15 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 10 & 0x1FL)], BASE32_CHARS[(int)(this.random2 >>> 5 & 0x1FL)], BASE32_CHARS[(int)(this.random2 & 0x1FL)]};
        return new String(chars);
    }

    public UUID toUuid() {
        long msb = this.time << 16 | this.random1 >>> 24;
        long lsb = this.random1 << 40 | this.random2;
        return new UUID(msb, lsb);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.random1 ^ this.random1 >>> 32);
        result = 31 * result + (int)(this.random2 ^ this.random2 >>> 32);
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UlidStruct other = (UlidStruct)obj;
        if (this.random1 != other.random1) {
            return false;
        }
        if (this.random2 != other.random2) {
            return false;
        }
        return this.time == other.time;
    }

    static {
        UlidStruct.BASE32_VALUES[48] = 0L;
        UlidStruct.BASE32_VALUES[49] = 1L;
        UlidStruct.BASE32_VALUES[50] = 2L;
        UlidStruct.BASE32_VALUES[51] = 3L;
        UlidStruct.BASE32_VALUES[52] = 4L;
        UlidStruct.BASE32_VALUES[53] = 5L;
        UlidStruct.BASE32_VALUES[54] = 6L;
        UlidStruct.BASE32_VALUES[55] = 7L;
        UlidStruct.BASE32_VALUES[56] = 8L;
        UlidStruct.BASE32_VALUES[57] = 9L;
        UlidStruct.BASE32_VALUES[97] = 10L;
        UlidStruct.BASE32_VALUES[98] = 11L;
        UlidStruct.BASE32_VALUES[99] = 12L;
        UlidStruct.BASE32_VALUES[100] = 13L;
        UlidStruct.BASE32_VALUES[101] = 14L;
        UlidStruct.BASE32_VALUES[102] = 15L;
        UlidStruct.BASE32_VALUES[103] = 16L;
        UlidStruct.BASE32_VALUES[104] = 17L;
        UlidStruct.BASE32_VALUES[106] = 18L;
        UlidStruct.BASE32_VALUES[107] = 19L;
        UlidStruct.BASE32_VALUES[109] = 20L;
        UlidStruct.BASE32_VALUES[110] = 21L;
        UlidStruct.BASE32_VALUES[112] = 22L;
        UlidStruct.BASE32_VALUES[113] = 23L;
        UlidStruct.BASE32_VALUES[114] = 24L;
        UlidStruct.BASE32_VALUES[115] = 25L;
        UlidStruct.BASE32_VALUES[116] = 26L;
        UlidStruct.BASE32_VALUES[118] = 27L;
        UlidStruct.BASE32_VALUES[119] = 28L;
        UlidStruct.BASE32_VALUES[120] = 29L;
        UlidStruct.BASE32_VALUES[121] = 30L;
        UlidStruct.BASE32_VALUES[122] = 31L;
        UlidStruct.BASE32_VALUES[111] = 0L;
        UlidStruct.BASE32_VALUES[105] = 1L;
        UlidStruct.BASE32_VALUES[108] = 1L;
        UlidStruct.BASE32_VALUES[65] = 10L;
        UlidStruct.BASE32_VALUES[66] = 11L;
        UlidStruct.BASE32_VALUES[67] = 12L;
        UlidStruct.BASE32_VALUES[68] = 13L;
        UlidStruct.BASE32_VALUES[69] = 14L;
        UlidStruct.BASE32_VALUES[70] = 15L;
        UlidStruct.BASE32_VALUES[71] = 16L;
        UlidStruct.BASE32_VALUES[72] = 17L;
        UlidStruct.BASE32_VALUES[74] = 18L;
        UlidStruct.BASE32_VALUES[75] = 19L;
        UlidStruct.BASE32_VALUES[77] = 20L;
        UlidStruct.BASE32_VALUES[78] = 21L;
        UlidStruct.BASE32_VALUES[80] = 22L;
        UlidStruct.BASE32_VALUES[81] = 23L;
        UlidStruct.BASE32_VALUES[82] = 24L;
        UlidStruct.BASE32_VALUES[83] = 25L;
        UlidStruct.BASE32_VALUES[84] = 26L;
        UlidStruct.BASE32_VALUES[86] = 27L;
        UlidStruct.BASE32_VALUES[87] = 28L;
        UlidStruct.BASE32_VALUES[88] = 29L;
        UlidStruct.BASE32_VALUES[89] = 30L;
        UlidStruct.BASE32_VALUES[90] = 31L;
        UlidStruct.BASE32_VALUES[79] = 0L;
        UlidStruct.BASE32_VALUES[73] = 1L;
        UlidStruct.BASE32_VALUES[76] = 1L;
    }
}

