/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.ulid.util;

import com.github.f4b6a3.ulid.util.UlidValidator;
import com.github.f4b6a3.util.Base32Util;
import com.github.f4b6a3.util.ByteUtil;
import java.util.UUID;

public class UlidConverter {
    private UlidConverter() {
    }

    public static String toString(UUID uuid) {
        long msb = uuid.getMostSignificantBits();
        long lsb = uuid.getLeastSignificantBits();
        long timeNumber = msb >>> 16;
        String timestampComponent = UlidConverter.leftPad(Base32Util.toBase32Crockford((long)timeNumber));
        byte[] randBytes = new byte[10];
        randBytes[0] = (byte)(msb >>> 8);
        randBytes[1] = (byte)msb;
        byte[] lsbBytes = ByteUtil.toBytes((long)lsb);
        System.arraycopy(lsbBytes, 0, randBytes, 2, 8);
        String randomnessComponent = Base32Util.toBase32Crockford((byte[])randBytes);
        return timestampComponent + randomnessComponent;
    }

    public static UUID fromString(String ulid) {
        UlidValidator.validate(ulid);
        String timestampComponent = ulid.substring(0, 10);
        long timeNumber = Base32Util.fromBase32CrockfordAsLong((String)timestampComponent);
        String randomnessComponent = ulid.substring(10, 26);
        byte[] randBytes = Base32Util.fromBase32Crockford((String)randomnessComponent);
        byte[] lsbBytes = new byte[8];
        System.arraycopy(randBytes, 2, lsbBytes, 0, 8);
        long msb = timeNumber << 16 | (long)(randBytes[0] << 8) & 0xFF00L | (long)randBytes[1] & 0xFFL;
        long lsb = ByteUtil.toNumber((byte[])lsbBytes);
        return new UUID(msb, lsb);
    }

    private static String leftPad(String unpadded) {
        return "0000000000".substring(unpadded.length()) + unpadded;
    }
}

