/*
 * Decompiled with CFR 0.152.
 */
package com.github.exabrial.jca.udp.ra;

import com.github.exabrial.jca.udp.UDPMessageListener;
import com.github.exabrial.jca.udp.ra.UDPUtil;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPClientWorker
implements Work {
    private static final String ON_PACKET = "onPacket";
    private static final Logger log = LoggerFactory.getLogger(UDPClientWorker.class);
    private final MessageEndpointFactory messageEndpointFactory;
    private final DatagramSocket datagramSocket;
    private final UDPUtil.InboundPacket inboundPacket;
    private final Method onPacketMethod;

    public UDPClientWorker(MessageEndpointFactory messageEndpointFactory, DatagramSocket datagramSocket, UDPUtil.InboundPacket inboundPacket) {
        this.messageEndpointFactory = messageEndpointFactory;
        this.datagramSocket = datagramSocket;
        this.inboundPacket = inboundPacket;
        try {
            this.onPacketMethod = UDPMessageListener.class.getMethod(ON_PACKET, byte[].class, InetAddress.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        MessageEndpoint messageEndpoint = null;
        try {
            log.trace("run() inboundPacket:{}", (Object)this.inboundPacket);
            messageEndpoint = this.messageEndpointFactory.createEndpoint(null);
            messageEndpoint.beforeDelivery(this.onPacketMethod);
            UDPMessageListener messageListener = (UDPMessageListener)messageEndpoint;
            byte[] reply = messageListener.onPacket(this.inboundPacket.getData(), this.inboundPacket.getSourceAddress());
            if (reply != null) {
                log.trace("run() replying:{}", (Object)reply);
                UDPUtil.send(this.datagramSocket, new UDPUtil.InboundPacket(reply, this.inboundPacket.getSourceAddress(), this.inboundPacket.getSourcePort()));
            }
            messageEndpoint.afterDelivery();
            log.trace("run() UDPClientWorker complete");
        }
        catch (Exception e) {
            log.error("run() error occured while handling packet", (Throwable)e);
            log.error("run() inboundPacket:{}", (Object)this.inboundPacket);
        }
        finally {
            if (messageEndpoint != null) {
                messageEndpoint.release();
            }
        }
    }

    public void release() {
    }
}

