/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.listener.ITableViewListener;

public abstract class AbstractItemClickListener
implements RecyclerView.OnItemTouchListener {
    private ITableViewListener mListener;
    @NonNull
    protected GestureDetector mGestureDetector;
    @NonNull
    protected CellRecyclerView mRecyclerView;
    @NonNull
    protected SelectionHandler mSelectionHandler;
    @NonNull
    protected ITableView mTableView;

    public AbstractItemClickListener(@NonNull CellRecyclerView recyclerView, @NonNull ITableView tableView) {
        this.mRecyclerView = recyclerView;
        this.mTableView = tableView;
        this.mSelectionHandler = tableView.getSelectionHandler();
        this.mGestureDetector = new GestureDetector(this.mRecyclerView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){
            @Nullable
            MotionEvent start;

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return AbstractItemClickListener.this.clickAction(AbstractItemClickListener.this.mRecyclerView, e);
            }

            public boolean onDown(MotionEvent e) {
                this.start = e;
                return false;
            }

            public void onLongPress(MotionEvent e) {
                if (this.start != null && Math.abs(this.start.getRawX() - e.getRawX()) < 20.0f && Math.abs(this.start.getRawY() - e.getRawY()) < 20.0f) {
                    AbstractItemClickListener.this.longPressAction(e);
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(@NonNull RecyclerView view, @NonNull MotionEvent e) {
        this.mGestureDetector.onTouchEvent(e);
        return false;
    }

    public void onTouchEvent(@NonNull RecyclerView view, @NonNull MotionEvent motionEvent) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    @NonNull
    protected ITableViewListener getTableViewListener() {
        if (this.mListener == null) {
            this.mListener = this.mTableView.getTableViewListener();
        }
        return this.mListener;
    }

    protected abstract boolean clickAction(@NonNull RecyclerView var1, @NonNull MotionEvent var2);

    protected abstract void longPressAction(@NonNull MotionEvent var1);
}

