/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener;

import android.view.View;
import androidx.annotation.NonNull;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;

public class TableViewLayoutChangeListener
implements View.OnLayoutChangeListener {
    @NonNull
    private CellRecyclerView mCellRecyclerView;
    @NonNull
    private CellRecyclerView mColumnHeaderRecyclerView;
    @NonNull
    private CellLayoutManager mCellLayoutManager;

    public TableViewLayoutChangeListener(@NonNull ITableView tableView) {
        this.mCellRecyclerView = tableView.getCellRecyclerView();
        this.mColumnHeaderRecyclerView = tableView.getColumnHeaderRecyclerView();
        this.mCellLayoutManager = tableView.getCellLayoutManager();
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        if (v.isShown() && right - left != oldRight - oldLeft) {
            if (this.mColumnHeaderRecyclerView.getWidth() > this.mCellRecyclerView.getWidth()) {
                this.mCellLayoutManager.remeasureAllChild();
            } else if (this.mCellRecyclerView.getWidth() > this.mColumnHeaderRecyclerView.getWidth()) {
                this.mColumnHeaderRecyclerView.getLayoutParams().width = -2;
                this.mColumnHeaderRecyclerView.requestLayout();
            }
        }
    }
}

