/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.sort.RowHeaderSortHelper;
import java.util.List;

public class RowHeaderRecyclerViewAdapter<RH>
extends AbstractRecyclerViewAdapter<RH> {
    @NonNull
    private ITableAdapter mTableAdapter;
    private ITableView mTableView;
    private RowHeaderSortHelper mRowHeaderSortHelper;

    public RowHeaderRecyclerViewAdapter(@NonNull Context context, @Nullable List<RH> itemList, @NonNull ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
        this.mTableView = tableAdapter.getTableView();
    }

    @NonNull
    public AbstractViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.mTableAdapter.onCreateRowHeaderViewHolder(parent, viewType);
    }

    public void onBindViewHolder(@NonNull AbstractViewHolder holder, int position) {
        this.mTableAdapter.onBindRowHeaderViewHolder(holder, this.getItem(position), position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mTableAdapter.getRowHeaderItemViewType(position);
    }

    public void onViewAttachedToWindow(@NonNull AbstractViewHolder viewHolder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)viewHolder);
        AbstractViewHolder.SelectionState selectionState = this.mTableView.getSelectionHandler().getRowSelectionState(viewHolder.getAdapterPosition());
        if (!this.mTableView.isIgnoreSelectionColors()) {
            this.mTableView.getSelectionHandler().changeRowBackgroundColorBySelectionStatus(viewHolder, selectionState);
        }
        viewHolder.setSelected(selectionState);
    }

    @NonNull
    public RowHeaderSortHelper getRowHeaderSortHelper() {
        if (this.mRowHeaderSortHelper == null) {
            this.mRowHeaderSortHelper = new RowHeaderSortHelper();
        }
        return this.mRowHeaderSortHelper;
    }
}

