/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.R;
import com.evrencoskun.tableview.adapter.AbstractTableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.filter.Filter;
import com.evrencoskun.tableview.handler.ColumnSortHandler;
import com.evrencoskun.tableview.handler.ColumnWidthHandler;
import com.evrencoskun.tableview.handler.FilterHandler;
import com.evrencoskun.tableview.handler.PreferencesHandler;
import com.evrencoskun.tableview.handler.ScrollHandler;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.handler.VisibilityHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.listener.ITableViewListener;
import com.evrencoskun.tableview.listener.TableViewLayoutChangeListener;
import com.evrencoskun.tableview.listener.itemclick.ColumnHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.itemclick.RowHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;
import com.evrencoskun.tableview.preference.SavedState;
import com.evrencoskun.tableview.sort.SortState;

public class TableView
extends FrameLayout
implements ITableView {
    @NonNull
    protected CellRecyclerView mCellRecyclerView;
    @NonNull
    protected CellRecyclerView mColumnHeaderRecyclerView;
    @NonNull
    protected CellRecyclerView mRowHeaderRecyclerView;
    @Nullable
    protected AbstractTableAdapter mTableAdapter;
    @Nullable
    private ITableViewListener mTableViewListener;
    @NonNull
    private VerticalRecyclerViewListener mVerticalRecyclerListener;
    @NonNull
    private HorizontalRecyclerViewListener mHorizontalRecyclerViewListener;
    @NonNull
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    @NonNull
    private LinearLayoutManager mRowHeaderLayoutManager;
    @NonNull
    private CellLayoutManager mCellLayoutManager;
    @NonNull
    private DividerItemDecoration mVerticalItemDecoration;
    @NonNull
    private DividerItemDecoration mHorizontalItemDecoration;
    @NonNull
    private SelectionHandler mSelectionHandler;
    @Nullable
    private ColumnSortHandler mColumnSortHandler;
    @NonNull
    private VisibilityHandler mVisibilityHandler;
    @NonNull
    private ScrollHandler mScrollHandler;
    @Nullable
    private FilterHandler mFilterHandler;
    @NonNull
    private PreferencesHandler mPreferencesHandler;
    @NonNull
    private ColumnWidthHandler mColumnWidthHandler;
    private int mRowHeaderWidth;
    private int mColumnHeaderHeight;
    private int mSelectedColor;
    private int mUnSelectedColor;
    private int mShadowColor;
    private int mSeparatorColor = -1;
    private boolean mHasFixedWidth;
    private boolean mIgnoreSelectionColors;
    private boolean mShowHorizontalSeparators = true;
    private boolean mShowVerticalSeparators = true;
    private boolean mAllowClickInsideCell = false;
    private boolean mAllowClickInsideRowHeader = false;
    private boolean mAllowClickInsideColumnHeader = false;
    private boolean mIsSortable;

    public TableView(@NonNull Context context) {
        super(context);
        this.initialDefaultValues(null);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialDefaultValues(attrs);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialDefaultValues(null);
        this.initialize();
    }

    private void initialDefaultValues(@Nullable AttributeSet attrs) {
        this.mRowHeaderWidth = (int)this.getResources().getDimension(R.dimen.default_row_header_width);
        this.mColumnHeaderHeight = (int)this.getResources().getDimension(R.dimen.default_column_header_height);
        this.mSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_selected_background_color);
        this.mUnSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_unselected_background_color);
        this.mShadowColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_shadow_background_color);
        if (attrs == null) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TableView, 0, 0);
        try {
            this.mRowHeaderWidth = (int)a.getDimension(R.styleable.TableView_row_header_width, (float)this.mRowHeaderWidth);
            this.mColumnHeaderHeight = (int)a.getDimension(R.styleable.TableView_column_header_height, (float)this.mColumnHeaderHeight);
            this.mSelectedColor = a.getColor(R.styleable.TableView_selected_color, this.mSelectedColor);
            this.mUnSelectedColor = a.getColor(R.styleable.TableView_unselected_color, this.mUnSelectedColor);
            this.mShadowColor = a.getColor(R.styleable.TableView_shadow_color, this.mShadowColor);
            this.mSeparatorColor = a.getColor(R.styleable.TableView_separator_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_separator_color));
            this.mShowVerticalSeparators = a.getBoolean(R.styleable.TableView_show_vertical_separator, this.mShowVerticalSeparators);
            this.mShowHorizontalSeparators = a.getBoolean(R.styleable.TableView_show_horizontal_separator, this.mShowHorizontalSeparators);
            this.mAllowClickInsideCell = a.getBoolean(R.styleable.TableView_allow_click_inside_cell, this.mAllowClickInsideCell);
            this.mAllowClickInsideRowHeader = a.getBoolean(R.styleable.TableView_allow_click_inside_row_header, this.mAllowClickInsideRowHeader);
            this.mAllowClickInsideColumnHeader = a.getBoolean(R.styleable.TableView_allow_click_inside_column_header, this.mAllowClickInsideColumnHeader);
        }
        finally {
            a.recycle();
        }
    }

    private void initialize() {
        this.mColumnHeaderRecyclerView = this.createColumnHeaderRecyclerView();
        this.mRowHeaderRecyclerView = this.createRowHeaderRecyclerView();
        this.mCellRecyclerView = this.createCellRecyclerView();
        this.addView((View)this.mColumnHeaderRecyclerView);
        this.addView((View)this.mRowHeaderRecyclerView);
        this.addView((View)this.mCellRecyclerView);
        this.mSelectionHandler = new SelectionHandler(this);
        this.mVisibilityHandler = new VisibilityHandler(this);
        this.mScrollHandler = new ScrollHandler(this);
        this.mPreferencesHandler = new PreferencesHandler(this);
        this.mColumnWidthHandler = new ColumnWidthHandler(this);
        this.initializeListeners();
    }

    protected void initializeListeners() {
        this.mVerticalRecyclerListener = new VerticalRecyclerViewListener(this);
        this.mRowHeaderRecyclerView.addOnItemTouchListener(this.mVerticalRecyclerListener);
        this.mCellRecyclerView.addOnItemTouchListener(this.mVerticalRecyclerListener);
        this.mHorizontalRecyclerViewListener = new HorizontalRecyclerViewListener(this);
        this.mColumnHeaderRecyclerView.addOnItemTouchListener(this.mHorizontalRecyclerViewListener);
        if (this.mAllowClickInsideColumnHeader) {
            ColumnHeaderRecyclerViewItemClickListener columnHeaderRecyclerViewItemClickListener = new ColumnHeaderRecyclerViewItemClickListener(this.mColumnHeaderRecyclerView, this);
            this.mColumnHeaderRecyclerView.addOnItemTouchListener(columnHeaderRecyclerViewItemClickListener);
        }
        if (this.mAllowClickInsideRowHeader) {
            RowHeaderRecyclerViewItemClickListener rowHeaderRecyclerViewItemClickListener = new RowHeaderRecyclerViewItemClickListener(this.mRowHeaderRecyclerView, this);
            this.mRowHeaderRecyclerView.addOnItemTouchListener(rowHeaderRecyclerViewItemClickListener);
        }
        TableViewLayoutChangeListener layoutChangeListener = new TableViewLayoutChangeListener(this);
        this.mColumnHeaderRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
        this.mCellRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
    }

    @NonNull
    protected CellRecyclerView createColumnHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getColumnHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, this.mColumnHeaderHeight);
        layoutParams.leftMargin = this.mRowHeaderWidth;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowHorizontalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getHorizontalItemDecoration());
        }
        return recyclerView;
    }

    @NonNull
    protected CellRecyclerView createRowHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getRowHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.mRowHeaderWidth, -2);
        layoutParams.topMargin = this.mColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    @NonNull
    protected CellRecyclerView createCellRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setMotionEventSplittingEnabled(false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getCellLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = this.mRowHeaderWidth;
        layoutParams.topMargin = this.mColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    public <CH, RH, C> void setAdapter(@Nullable AbstractTableAdapter<CH, RH, C> tableAdapter) {
        if (tableAdapter != null) {
            this.mTableAdapter = tableAdapter;
            this.mTableAdapter.setRowHeaderWidth(this.mRowHeaderWidth);
            this.mTableAdapter.setColumnHeaderHeight(this.mColumnHeaderHeight);
            this.mTableAdapter.setTableView(this);
            this.mColumnHeaderRecyclerView.setAdapter(this.mTableAdapter.getColumnHeaderRecyclerViewAdapter());
            this.mRowHeaderRecyclerView.setAdapter(this.mTableAdapter.getRowHeaderRecyclerViewAdapter());
            this.mCellRecyclerView.setAdapter(this.mTableAdapter.getCellRecyclerViewAdapter());
            this.mColumnSortHandler = new ColumnSortHandler(this);
            this.mFilterHandler = new FilterHandler(this);
        }
    }

    @Override
    public boolean hasFixedWidth() {
        return this.mHasFixedWidth;
    }

    public void setHasFixedWidth(boolean hasFixedWidth) {
        this.mHasFixedWidth = hasFixedWidth;
        this.mColumnHeaderRecyclerView.setHasFixedSize(hasFixedWidth);
    }

    @Override
    public boolean isIgnoreSelectionColors() {
        return this.mIgnoreSelectionColors;
    }

    public void setIgnoreSelectionColors(boolean ignoreSelectionColor) {
        this.mIgnoreSelectionColors = ignoreSelectionColor;
    }

    @Override
    public boolean isShowHorizontalSeparators() {
        return this.mShowHorizontalSeparators;
    }

    @Override
    public boolean isAllowClickInsideCell() {
        return this.mAllowClickInsideCell;
    }

    @Override
    public boolean isSortable() {
        return this.mIsSortable;
    }

    public void setShowHorizontalSeparators(boolean showSeparators) {
        this.mShowHorizontalSeparators = showSeparators;
    }

    @Override
    public boolean isShowVerticalSeparators() {
        return this.mShowVerticalSeparators;
    }

    public void setShowVerticalSeparators(boolean showSeparators) {
        this.mShowVerticalSeparators = showSeparators;
    }

    @Override
    @NonNull
    public CellRecyclerView getCellRecyclerView() {
        return this.mCellRecyclerView;
    }

    @Override
    @NonNull
    public CellRecyclerView getColumnHeaderRecyclerView() {
        return this.mColumnHeaderRecyclerView;
    }

    @Override
    @NonNull
    public CellRecyclerView getRowHeaderRecyclerView() {
        return this.mRowHeaderRecyclerView;
    }

    @Override
    @NonNull
    public ColumnHeaderLayoutManager getColumnHeaderLayoutManager() {
        if (this.mColumnHeaderLayoutManager == null) {
            this.mColumnHeaderLayoutManager = new ColumnHeaderLayoutManager(this.getContext(), this);
        }
        return this.mColumnHeaderLayoutManager;
    }

    @Override
    @NonNull
    public CellLayoutManager getCellLayoutManager() {
        if (this.mCellLayoutManager == null) {
            this.mCellLayoutManager = new CellLayoutManager(this.getContext(), this);
        }
        return this.mCellLayoutManager;
    }

    @Override
    @NonNull
    public LinearLayoutManager getRowHeaderLayoutManager() {
        if (this.mRowHeaderLayoutManager == null) {
            this.mRowHeaderLayoutManager = new LinearLayoutManager(this.getContext(), 1, false);
        }
        return this.mRowHeaderLayoutManager;
    }

    @Override
    @NonNull
    public HorizontalRecyclerViewListener getHorizontalRecyclerViewListener() {
        return this.mHorizontalRecyclerViewListener;
    }

    @Override
    @NonNull
    public VerticalRecyclerViewListener getVerticalRecyclerViewListener() {
        return this.mVerticalRecyclerListener;
    }

    @Override
    @Nullable
    public ITableViewListener getTableViewListener() {
        return this.mTableViewListener;
    }

    public void setTableViewListener(@Nullable ITableViewListener tableViewListener) {
        this.mTableViewListener = tableViewListener;
    }

    @Override
    public void sortColumn(int columnPosition, @NonNull SortState sortState) {
        this.mIsSortable = true;
        this.mColumnSortHandler.sort(columnPosition, sortState);
    }

    @Override
    public void sortRowHeader(@NonNull SortState sortState) {
        this.mIsSortable = true;
        this.mColumnSortHandler.sortByRowHeader(sortState);
    }

    @Override
    public void remeasureColumnWidth(int column) {
        this.getColumnHeaderLayoutManager().removeCachedWidth(column);
        this.getCellLayoutManager().fitWidthSize(column, false);
    }

    @Override
    @Nullable
    public AbstractTableAdapter getAdapter() {
        return this.mTableAdapter;
    }

    @Override
    public void filter(@NonNull Filter filter) {
        this.mFilterHandler.filter(filter);
    }

    @Override
    @Nullable
    public FilterHandler getFilterHandler() {
        return this.mFilterHandler;
    }

    @Override
    @NonNull
    public SortState getSortingStatus(int column) {
        return this.mColumnSortHandler.getSortingStatus(column);
    }

    @Override
    @Nullable
    public SortState getRowHeaderSortingStatus() {
        return this.mColumnSortHandler.getRowHeaderSortingStatus();
    }

    @Override
    public void scrollToColumnPosition(int column) {
        this.mScrollHandler.scrollToColumnPosition(column);
    }

    @Override
    public void scrollToColumnPosition(int column, int offset) {
        this.mScrollHandler.scrollToColumnPosition(column, offset);
    }

    @Override
    public void scrollToRowPosition(int row) {
        this.mScrollHandler.scrollToRowPosition(row);
    }

    @Override
    public void scrollToRowPosition(int row, int offset) {
        this.mScrollHandler.scrollToRowPosition(row, offset);
    }

    @Override
    @NonNull
    public ScrollHandler getScrollHandler() {
        return this.mScrollHandler;
    }

    @Override
    public void showRow(int row) {
        this.mVisibilityHandler.showRow(row);
    }

    @Override
    public void hideRow(int row) {
        this.mVisibilityHandler.hideRow(row);
    }

    @Override
    public void showAllHiddenRows() {
        this.mVisibilityHandler.showAllHiddenRows();
    }

    @Override
    public void clearHiddenRowList() {
        this.mVisibilityHandler.clearHideRowList();
    }

    @Override
    public void showColumn(int column) {
        this.mVisibilityHandler.showColumn(column);
    }

    @Override
    public void hideColumn(int column) {
        this.mVisibilityHandler.hideColumn(column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.mVisibilityHandler.isColumnVisible(column);
    }

    @Override
    public void showAllHiddenColumns() {
        this.mVisibilityHandler.showAllHiddenColumns();
    }

    @Override
    public void clearHiddenColumnList() {
        this.mVisibilityHandler.clearHideColumnList();
    }

    @Override
    public boolean isRowVisible(int row) {
        return this.mVisibilityHandler.isRowVisible(row);
    }

    public int getSelectedRow() {
        return this.mSelectionHandler.getSelectedRowPosition();
    }

    public void setSelectedRow(int row) {
        AbstractViewHolder rowViewHolder = (AbstractViewHolder)this.getRowHeaderRecyclerView().findViewHolderForAdapterPosition(row);
        this.mSelectionHandler.setSelectedRowPosition(rowViewHolder, row);
    }

    public int getSelectedColumn() {
        return this.mSelectionHandler.getSelectedColumnPosition();
    }

    public void setSelectedColumn(int column) {
        AbstractViewHolder columnViewHolder = (AbstractViewHolder)this.getColumnHeaderRecyclerView().findViewHolderForAdapterPosition(column);
        this.mSelectionHandler.setSelectedColumnPosition(columnViewHolder, column);
    }

    public void setSelectedCell(int column, int row) {
        AbstractViewHolder cellViewHolder = this.getCellLayoutManager().getCellViewHolder(column, row);
        this.mSelectionHandler.setSelectedCellPositions(cellViewHolder, column, row);
    }

    @Override
    @NonNull
    public SelectionHandler getSelectionHandler() {
        return this.mSelectionHandler;
    }

    @Override
    @Nullable
    public ColumnSortHandler getColumnSortHandler() {
        return this.mColumnSortHandler;
    }

    @Override
    @NonNull
    public VisibilityHandler getVisibilityHandler() {
        return this.mVisibilityHandler;
    }

    @Override
    @NonNull
    public DividerItemDecoration getHorizontalItemDecoration() {
        if (this.mHorizontalItemDecoration == null) {
            this.mHorizontalItemDecoration = this.createItemDecoration(0);
        }
        return this.mHorizontalItemDecoration;
    }

    @Override
    @NonNull
    public DividerItemDecoration getVerticalItemDecoration() {
        if (this.mVerticalItemDecoration == null) {
            this.mVerticalItemDecoration = this.createItemDecoration(1);
        }
        return this.mVerticalItemDecoration;
    }

    @NonNull
    protected DividerItemDecoration createItemDecoration(int orientation) {
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.getContext(), orientation);
        Drawable divider = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.cell_line_divider);
        if (divider == null) {
            return itemDecoration;
        }
        if (this.mSeparatorColor != -1) {
            divider.setColorFilter(this.mSeparatorColor, PorterDuff.Mode.SRC_ATOP);
        }
        itemDecoration.setDrawable(divider);
        return itemDecoration;
    }

    public void setSelectedColor(@ColorInt int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    @Override
    @ColorInt
    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setSeparatorColor(@ColorInt int mSeparatorColor) {
        this.mSeparatorColor = mSeparatorColor;
    }

    @Override
    @ColorInt
    public int getSeparatorColor() {
        return this.mSeparatorColor;
    }

    public void setUnSelectedColor(@ColorInt int unSelectedColor) {
        this.mUnSelectedColor = unSelectedColor;
    }

    @Override
    @ColorInt
    public int getUnSelectedColor() {
        return this.mUnSelectedColor;
    }

    public void setShadowColor(@ColorInt int shadowColor) {
        this.mShadowColor = shadowColor;
    }

    @Override
    @ColorInt
    public int getShadowColor() {
        return this.mShadowColor;
    }

    @Override
    public int getRowHeaderWidth() {
        return this.mRowHeaderWidth;
    }

    @Override
    public void setRowHeaderWidth(int rowHeaderWidth) {
        this.mRowHeaderWidth = rowHeaderWidth;
        ViewGroup.LayoutParams layoutParamsRow = this.mRowHeaderRecyclerView.getLayoutParams();
        layoutParamsRow.width = rowHeaderWidth;
        this.mRowHeaderRecyclerView.setLayoutParams(layoutParamsRow);
        this.mRowHeaderRecyclerView.requestLayout();
        FrameLayout.LayoutParams layoutParamsColumn = (FrameLayout.LayoutParams)this.mColumnHeaderRecyclerView.getLayoutParams();
        layoutParamsColumn.leftMargin = rowHeaderWidth;
        this.mColumnHeaderRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsColumn);
        this.mColumnHeaderRecyclerView.requestLayout();
        FrameLayout.LayoutParams layoutParamsCell = (FrameLayout.LayoutParams)this.mCellRecyclerView.getLayoutParams();
        layoutParamsCell.leftMargin = rowHeaderWidth;
        this.mCellRecyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsCell);
        this.mCellRecyclerView.requestLayout();
        if (this.getAdapter() != null) {
            this.getAdapter().setRowHeaderWidth(rowHeaderWidth);
        }
    }

    public void setColumnWidth(int columnPosition, int width) {
        this.mColumnWidthHandler.setColumnWidth(columnPosition, width);
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.preferences = this.mPreferencesHandler.savePreferences();
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mPreferencesHandler.loadPreferences(savedState.preferences);
    }
}

