/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import android.support.v7.util.DiffUtil;
import com.evrencoskun.tableview.sort.ISortableModel;
import java.util.List;

public class ColumnSortCallback
extends DiffUtil.Callback {
    private static final String LOG_TAG = ColumnSortCallback.class.getSimpleName();
    private List<List<ISortableModel>> mOldCellItems;
    private List<List<ISortableModel>> mNewCellItems;
    private int mColumnPosition;

    public ColumnSortCallback(List<List<ISortableModel>> oldCellItems, List<List<ISortableModel>> newCellItems, int column) {
        this.mOldCellItems = oldCellItems;
        this.mNewCellItems = newCellItems;
        this.mColumnPosition = column;
    }

    public int getOldListSize() {
        return this.mOldCellItems.size();
    }

    public int getNewListSize() {
        return this.mNewCellItems.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mOldCellItems.size() > oldItemPosition && this.mNewCellItems.size() > newItemPosition && this.mOldCellItems.get(oldItemPosition).size() > this.mColumnPosition && this.mNewCellItems.get(newItemPosition).size() > this.mColumnPosition) {
            String oldId = this.mOldCellItems.get(oldItemPosition).get(this.mColumnPosition).getId();
            String newId = this.mNewCellItems.get(newItemPosition).get(this.mColumnPosition).getId();
            return oldId.equals(newId);
        }
        return false;
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.mOldCellItems.size() > oldItemPosition && this.mNewCellItems.size() > newItemPosition && this.mOldCellItems.get(oldItemPosition).size() > this.mColumnPosition && this.mNewCellItems.get(newItemPosition).size() > this.mColumnPosition) {
            Object oldContent = this.mOldCellItems.get(oldItemPosition).get(this.mColumnPosition).getContent();
            Object newContent = this.mNewCellItems.get(newItemPosition).get(this.mColumnPosition).getContent();
            return oldContent.equals(newContent);
        }
        return false;
    }
}

