/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.listener.ITableViewListener;

public abstract class AbstractItemClickListener
implements RecyclerView.OnItemTouchListener {
    private ITableViewListener mListener;
    protected GestureDetector mGestureDetector;
    protected CellRecyclerView mRecyclerView;
    protected SelectionHandler mSelectionHandler;
    protected ITableView mTableView;

    public AbstractItemClickListener(CellRecyclerView recyclerView, ITableView tableView) {
        this.mRecyclerView = recyclerView;
        this.mTableView = tableView;
        this.mSelectionHandler = tableView.getSelectionHandler();
        this.mGestureDetector = new GestureDetector(this.mRecyclerView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){
            MotionEvent start;

            public boolean onSingleTapUp(MotionEvent e) {
                return true;
            }

            public boolean onDown(MotionEvent e) {
                this.start = e;
                return false;
            }

            public void onLongPress(MotionEvent e) {
                if (this.start != null && Math.abs(this.start.getRawX() - e.getRawX()) < 20.0f && Math.abs(this.start.getRawY() - e.getRawY()) < 20.0f) {
                    AbstractItemClickListener.this.longPressAction(e);
                }
            }
        });
    }

    public boolean onInterceptTouchEvent(RecyclerView view, MotionEvent e) {
        return this.clickAction(view, e);
    }

    public void onTouchEvent(RecyclerView view, MotionEvent motionEvent) {
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    protected ITableViewListener getTableViewListener() {
        if (this.mListener == null) {
            this.mListener = this.mTableView.getTableViewListener();
        }
        return this.mListener;
    }

    protected abstract boolean clickAction(RecyclerView var1, MotionEvent var2);

    protected abstract void longPressAction(MotionEvent var1);
}

