/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;

public class ScrollHandler {
    private ITableView mTableView;
    private CellLayoutManager mCellLayoutManager;
    private LinearLayoutManager mRowHeaderLayoutManager;
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;

    public ScrollHandler(ITableView tableView) {
        this.mTableView = tableView;
        this.mCellLayoutManager = tableView.getCellLayoutManager();
        this.mRowHeaderLayoutManager = tableView.getRowHeaderLayoutManager();
        this.mColumnHeaderLayoutManager = tableView.getColumnHeaderLayoutManager();
    }

    public void scrollToColumnPosition(int columnPosition) {
        if (!((View)this.mTableView).isShown()) {
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPosition(columnPosition);
        }
        this.scrollColumnHeader(columnPosition, 0);
        this.scrollCellHorizontally(columnPosition, 0);
    }

    public void scrollToColumnPosition(int columnPosition, int offset) {
        if (!((View)this.mTableView).isShown()) {
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPosition(columnPosition);
            this.mTableView.getHorizontalRecyclerViewListener().setScrollPositionOffset(offset);
        }
        this.scrollColumnHeader(columnPosition, offset);
        this.scrollCellHorizontally(columnPosition, offset);
    }

    public void scrollToRowPosition(int rowPosition) {
        this.mRowHeaderLayoutManager.scrollToPosition(rowPosition);
        this.mCellLayoutManager.scrollToPosition(rowPosition);
    }

    public void scrollToRowPosition(int rowPosition, int offset) {
        this.mRowHeaderLayoutManager.scrollToPositionWithOffset(rowPosition, offset);
        this.mCellLayoutManager.scrollToPositionWithOffset(rowPosition, offset);
    }

    private void scrollCellHorizontally(int columnPosition, int offset) {
        CellLayoutManager cellLayoutManager = this.mTableView.getCellLayoutManager();
        for (int i = cellLayoutManager.findFirstVisibleItemPosition(); i < cellLayoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)cellLayoutManager.findViewByPosition(i);
            if (cellRowRecyclerView == null) continue;
            ColumnLayoutManager columnLayoutManager = (ColumnLayoutManager)cellRowRecyclerView.getLayoutManager();
            columnLayoutManager.scrollToPositionWithOffset(columnPosition, offset);
        }
    }

    private void scrollColumnHeader(int columnPosition, int offset) {
        this.mTableView.getColumnHeaderLayoutManager().scrollToPositionWithOffset(columnPosition, offset);
    }

    public int getColumnPosition() {
        return this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition();
    }

    public int getColumnPositionOffset() {
        View child = this.mColumnHeaderLayoutManager.findViewByPosition(this.mColumnHeaderLayoutManager.findFirstVisibleItemPosition());
        if (child != null) {
            return child.getLeft();
        }
        return 0;
    }

    public int getRowPosition() {
        return this.mRowHeaderLayoutManager.findFirstVisibleItemPosition();
    }

    public int getRowPositionOffset() {
        View child = this.mRowHeaderLayoutManager.findViewByPosition(this.mRowHeaderLayoutManager.findFirstVisibleItemPosition());
        if (child != null) {
            return child.getLeft();
        }
        return 0;
    }
}

