/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class CellRecyclerViewItemClickListener
extends AbstractItemClickListener {
    private static final String LOG_TAG = CellRecyclerViewItemClickListener.class.getSimpleName();
    private CellRecyclerView mCellRecyclerView;

    public CellRecyclerViewItemClickListener(CellRecyclerView recyclerView, ITableView tableView) {
        super(recyclerView, tableView);
        this.mCellRecyclerView = tableView.getCellRecyclerView();
    }

    @Override
    protected boolean clickAction(RecyclerView view, MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null && this.mGestureDetector.onTouchEvent(e)) {
            AbstractViewHolder holder = (AbstractViewHolder)this.mRecyclerView.getChildViewHolder(childView);
            CellRowRecyclerViewAdapter adapter = (CellRowRecyclerViewAdapter)this.mRecyclerView.getAdapter();
            int column = holder.getAdapterPosition();
            int row = adapter.getYPosition();
            if (!this.mTableView.isIgnoreSelectionColors()) {
                this.mSelectionHandler.setSelectedCellPositions(holder, column, row);
            }
            if (this.getTableViewListener() != null) {
                this.getTableViewListener().onCellClicked(holder, column, row);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(MotionEvent e) {
        if (this.mRecyclerView.getScrollState() != 0 || this.mCellRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.mRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null && this.getTableViewListener() != null) {
            RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(child);
            CellRowRecyclerViewAdapter adapter = (CellRowRecyclerViewAdapter)this.mRecyclerView.getAdapter();
            this.getTableViewListener().onCellLongPressed(holder, holder.getAdapterPosition(), adapter.getYPosition());
        }
    }
}

