/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.layoutmanager;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.util.TableViewUtils;

public class ColumnLayoutManager
extends LinearLayoutManager {
    private static final String LOG_TAG = ColumnLayoutManager.class.getSimpleName();
    private SparseArray<SparseArray<Integer>> mCachedWidthList;
    private ITableView mTableView;
    private CellRecyclerView mCellRowRecyclerView;
    private CellRecyclerView mColumnHeaderRecyclerView;
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    private CellLayoutManager mCellLayoutManager;
    private int mLastDx = 0;
    private boolean mNeedFit;

    public ColumnLayoutManager(Context context, ITableView tableView, CellRecyclerView cellRowRecyclerView) {
        super(context);
        this.mTableView = tableView;
        this.mColumnHeaderRecyclerView = this.mTableView.getColumnHeaderRecyclerView();
        this.mColumnHeaderLayoutManager = this.mTableView.getColumnHeaderLayoutManager();
        this.mCellRowRecyclerView = cellRowRecyclerView;
        this.mCellLayoutManager = this.mTableView.getCellLayoutManager();
        this.mCachedWidthList = new SparseArray();
        this.setOrientation(0);
    }

    public void measureChildWithMargins(View child, int widthUsed, int heightUsed) {
        super.measureChildWithMargins(child, widthUsed, heightUsed);
        if (this.mTableView.hasFixedWidth()) {
            return;
        }
        this.measureChild(child, widthUsed, heightUsed);
    }

    public void measureChild(View child, int widthUsed, int heightUsed) {
        if (this.mTableView.hasFixedWidth()) {
            super.measureChild(child, widthUsed, heightUsed);
            return;
        }
        int position = this.getPosition(child);
        int cacheWidth = this.getCacheWidth(position);
        int columnCacheWidth = this.mColumnHeaderLayoutManager.getCacheWidth(position);
        if (cacheWidth != -1 && cacheWidth == columnCacheWidth) {
            TableViewUtils.setWidth(child, cacheWidth);
        } else {
            this.fitWidthSize(child, position, cacheWidth, columnCacheWidth);
        }
        if (this.shouldFitColumns(position)) {
            if (this.mLastDx < 0) {
                Log.e((String)LOG_TAG, (String)("x: " + position + " y: " + this.getRowPosition() + " fitWidthSize left side"));
                this.mCellLayoutManager.fitWidthSize(position, true);
            } else {
                this.mCellLayoutManager.fitWidthSize(position, false);
                Log.e((String)LOG_TAG, (String)("x: " + position + " y: " + this.getRowPosition() + " fitWidthSize right side"));
            }
            this.mNeedFit = false;
        }
    }

    private boolean shouldFitColumns(int xPosition) {
        int yPosition;
        return this.mNeedFit && this.mCellLayoutManager.shouldFitColumns(yPosition = this.mCellLayoutManager.getPosition((View)this.mCellRowRecyclerView)) && (this.mLastDx > 0 ? xPosition == this.findLastVisibleItemPosition() : this.mLastDx < 0 && xPosition == this.findFirstVisibleItemPosition());
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mColumnHeaderRecyclerView.getScrollState() == 0 && this.mCellRowRecyclerView.isScrollOthers()) {
            this.mColumnHeaderRecyclerView.scrollBy(dx, 0);
        }
        this.mLastDx = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    private void fitWidthSize(View child, int position, int cellCacheWidth, int columnCacheWidth) {
        View columnHeaderChild;
        int cellWidth = cellCacheWidth;
        if (cellWidth == -1) {
            cellWidth = child.getMeasuredWidth();
        }
        if (position > -1 && (columnHeaderChild = this.mColumnHeaderLayoutManager.findViewByPosition(position)) != null) {
            int columnHeaderWidth = columnCacheWidth;
            if (columnHeaderWidth == -1) {
                columnHeaderWidth = columnHeaderChild.getMeasuredWidth();
            }
            if (cellWidth != 0) {
                if (columnHeaderWidth > cellWidth) {
                    cellWidth = columnHeaderWidth;
                } else if (cellWidth > columnHeaderWidth) {
                    columnHeaderWidth = cellWidth;
                }
                if (columnHeaderWidth != columnHeaderChild.getWidth()) {
                    TableViewUtils.setWidth(columnHeaderChild, columnHeaderWidth);
                    this.mNeedFit = true;
                }
                this.mColumnHeaderLayoutManager.setCacheWidth(position, columnHeaderWidth);
            }
        }
        TableViewUtils.setWidth(child, cellWidth);
        this.setCacheWidth(position, cellWidth);
    }

    private int getRowPosition() {
        return this.mCellLayoutManager.getPosition((View)this.mCellRowRecyclerView);
    }

    public void setCacheWidth(int position, int width) {
        int yPosition = this.getRowPosition();
        SparseArray cellRowCaches = (SparseArray)this.mCachedWidthList.get(yPosition);
        if (cellRowCaches == null) {
            cellRowCaches = new SparseArray();
        }
        cellRowCaches.put(position, (Object)width);
        this.mCachedWidthList.put(yPosition, (Object)cellRowCaches);
    }

    public int getCacheWidth(int position) {
        Integer cachedWidth;
        int yPosition = this.getRowPosition();
        SparseArray cellRowCaches = (SparseArray)this.mCachedWidthList.get(yPosition);
        if (cellRowCaches != null && (cachedWidth = (Integer)cellRowCaches.get(position)) != null) {
            return (Integer)cellRowCaches.get(position);
        }
        return -1;
    }

    public int getLastDx() {
        return this.mLastDx;
    }

    public boolean isNeedFit() {
        return this.mNeedFit;
    }

    public void clearNeedFit() {
        this.mNeedFit = false;
    }

    public AbstractViewHolder[] getVisibleViewHolders() {
        int visibleChildCount = this.findLastVisibleItemPosition() - this.findFirstVisibleItemPosition() + 1;
        int index = 0;
        AbstractViewHolder[] views = new AbstractViewHolder[visibleChildCount];
        for (int i = this.findFirstVisibleItemPosition(); i < this.findLastVisibleItemPosition() + 1; ++i) {
            views[index] = (AbstractViewHolder)this.mCellRowRecyclerView.findViewHolderForAdapterPosition(i);
            ++index;
        }
        return views;
    }
}

