/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.adapter.recyclerview;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.ITableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.AbstractRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRowRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnLayoutManager;
import com.evrencoskun.tableview.listener.itemclick.CellRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import java.util.ArrayList;
import java.util.List;

public class CellRecyclerViewAdapter<C>
extends AbstractRecyclerViewAdapter<C> {
    private static final String LOG_TAG = CellRecyclerViewAdapter.class.getSimpleName();
    private ITableAdapter mTableAdapter;
    private HorizontalRecyclerViewListener mHorizontalListener;
    private int mRecyclerViewId = 0;

    public CellRecyclerViewAdapter(Context context, List<C> itemList, ITableAdapter tableAdapter) {
        super(context, itemList);
        this.mTableAdapter = tableAdapter;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        ITableView tableView = this.mTableAdapter.getTableView();
        CellRecyclerView recyclerView = new CellRecyclerView(this.mContext);
        if (tableView.isShowHorizontalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)tableView.getHorizontalItemDecoration());
        }
        if (tableView != null) {
            recyclerView.setHasFixedSize(tableView.hasFixedWidth());
            if (this.mHorizontalListener == null) {
                this.mHorizontalListener = tableView.getHorizontalRecyclerViewListener();
            }
            recyclerView.addOnItemTouchListener(this.mHorizontalListener);
            recyclerView.addOnItemTouchListener(new CellRecyclerViewItemClickListener(recyclerView, tableView));
            ColumnLayoutManager layoutManager = new ColumnLayoutManager(this.mContext, tableView, recyclerView);
            recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            recyclerView.setId(this.mRecyclerViewId);
            ++this.mRecyclerViewId;
        }
        return new CellRowViewHolder((View)recyclerView);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int yPosition) {
        if (!(holder instanceof CellRowViewHolder)) {
            return;
        }
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        List rowList = (List)this.mItemList.get(yPosition);
        CellRowRecyclerViewAdapter viewAdapter = new CellRowRecyclerViewAdapter(this.mContext, rowList, this.mTableAdapter, yPosition);
        viewHolder.m_jRecyclerView.setAdapter(viewAdapter);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        int colpos = this.mTableAdapter.getTableView().getScrollHandler().getColumnPosition();
        int colposoffset = this.mTableAdapter.getTableView().getScrollHandler().getColumnPositionOffset();
        ((ColumnLayoutManager)viewHolder.m_jRecyclerView.getLayoutManager()).scrollToPositionWithOffset(colpos, colposoffset);
        SelectionHandler selectionHandler = this.mTableAdapter.getTableView().getSelectionHandler();
        if (selectionHandler.isAnyColumnSelected()) {
            AbstractViewHolder cellViewHolder = (AbstractViewHolder)((CellRowViewHolder)holder).m_jRecyclerView.findViewHolderForAdapterPosition(selectionHandler.getSelectedColumnPosition());
            if (cellViewHolder != null) {
                if (!this.mTableAdapter.getTableView().isIgnoreSelectionColors()) {
                    cellViewHolder.setBackgroundColor(this.mTableAdapter.getTableView().getSelectedColor());
                }
                cellViewHolder.setSelected(AbstractViewHolder.SelectionState.SELECTED);
            }
        } else if (selectionHandler.isRowSelected(holder.getAdapterPosition())) {
            viewHolder.m_jRecyclerView.setSelected(AbstractViewHolder.SelectionState.SELECTED, this.mTableAdapter.getTableView().getSelectedColor(), this.mTableAdapter.getTableView().isIgnoreSelectionColors());
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
        ((CellRowViewHolder)holder).m_jRecyclerView.setSelected(AbstractViewHolder.SelectionState.UNSELECTED, this.mTableAdapter.getTableView().getUnSelectedColor(), this.mTableAdapter.getTableView().isIgnoreSelectionColors());
    }

    public void onViewRecycled(RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        CellRowViewHolder viewHolder = (CellRowViewHolder)holder;
        viewHolder.m_jRecyclerView.clearScrolledX();
    }

    public void notifyCellDataSetChanged() {
        CellRecyclerView[] visibleRecyclerViews = this.mTableAdapter.getTableView().getCellLayoutManager().getVisibleCellRowRecyclerViews();
        if (visibleRecyclerViews.length > 0) {
            for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews) {
                cellRowRecyclerView.getAdapter().notifyDataSetChanged();
            }
        } else {
            this.notifyDataSetChanged();
        }
    }

    public List<C> getColumnItems(int columnPosition) {
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            List rowList = (List)this.mItemList.get(i);
            if (rowList.size() <= columnPosition) continue;
            cellItems.add(rowList.get(columnPosition));
        }
        return cellItems;
    }

    public void removeColumnItems(int column) {
        CellRecyclerView[] visibleRecyclerViews;
        for (CellRecyclerView cellRowRecyclerView : visibleRecyclerViews = this.mTableAdapter.getTableView().getCellLayoutManager().getVisibleCellRowRecyclerViews()) {
            ((AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()).deleteItem(column);
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList rowList = new ArrayList((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.remove(column);
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    public void addColumnItems(int column, List<C> cellColumnItems) {
        if (cellColumnItems.size() != this.mItemList.size() || cellColumnItems.contains(null)) {
            return;
        }
        CellLayoutManager layoutManager = this.mTableAdapter.getTableView().getCellLayoutManager();
        for (int i = layoutManager.findFirstVisibleItemPosition(); i < layoutManager.findLastVisibleItemPosition() + 1; ++i) {
            RecyclerView cellRowRecyclerView = (RecyclerView)layoutManager.findViewByPosition(i);
            ((AbstractRecyclerViewAdapter)cellRowRecyclerView.getAdapter()).addItem(column, cellColumnItems.get(i));
        }
        ArrayList cellItems = new ArrayList();
        for (int i = 0; i < this.mItemList.size(); ++i) {
            ArrayList<C> rowList = new ArrayList<C>((List)this.mItemList.get(i));
            if (rowList.size() > column) {
                rowList.add(column, cellColumnItems.get(i));
            }
            cellItems.add(rowList);
        }
        this.setItems(cellItems, false);
    }

    static class CellRowViewHolder
    extends RecyclerView.ViewHolder {
        final CellRecyclerView m_jRecyclerView;

        CellRowViewHolder(View itemView) {
            super(itemView);
            this.m_jRecyclerView = (CellRecyclerView)itemView;
        }
    }
}

