/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.R;
import com.evrencoskun.tableview.adapter.AbstractTableAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.filter.Filter;
import com.evrencoskun.tableview.handler.ColumnSortHandler;
import com.evrencoskun.tableview.handler.FilterHandler;
import com.evrencoskun.tableview.handler.PreferencesHandler;
import com.evrencoskun.tableview.handler.ScrollHandler;
import com.evrencoskun.tableview.handler.SelectionHandler;
import com.evrencoskun.tableview.handler.VisibilityHandler;
import com.evrencoskun.tableview.layoutmanager.CellLayoutManager;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.listener.ITableViewListener;
import com.evrencoskun.tableview.listener.TableViewLayoutChangeListener;
import com.evrencoskun.tableview.listener.itemclick.ColumnHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.itemclick.RowHeaderRecyclerViewItemClickListener;
import com.evrencoskun.tableview.listener.scroll.HorizontalRecyclerViewListener;
import com.evrencoskun.tableview.listener.scroll.VerticalRecyclerViewListener;
import com.evrencoskun.tableview.preference.SavedState;
import com.evrencoskun.tableview.sort.SortState;

public class TableView
extends FrameLayout
implements ITableView {
    private static final String LOG_TAG = TableView.class.getSimpleName();
    protected CellRecyclerView mCellRecyclerView;
    protected CellRecyclerView mColumnHeaderRecyclerView;
    protected CellRecyclerView mRowHeaderRecyclerView;
    protected AbstractTableAdapter mTableAdapter;
    private ITableViewListener mTableViewListener;
    private VerticalRecyclerViewListener mVerticalRecyclerListener;
    private HorizontalRecyclerViewListener mHorizontalRecyclerViewListener;
    private ColumnHeaderRecyclerViewItemClickListener mColumnHeaderRecyclerViewItemClickListener;
    private RowHeaderRecyclerViewItemClickListener mRowHeaderRecyclerViewItemClickListener;
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    private LinearLayoutManager mRowHeaderLayoutManager;
    private CellLayoutManager mCellLayoutManager;
    private DividerItemDecoration mVerticalItemDecoration;
    private DividerItemDecoration mHorizontalItemDecoration;
    private SelectionHandler mSelectionHandler;
    private ColumnSortHandler mColumnSortHandler;
    private VisibilityHandler mVisibilityHandler;
    private ScrollHandler mScrollHandler;
    private FilterHandler mFilterHandler;
    private PreferencesHandler mPreferencesHandler;
    private int mRowHeaderWidth;
    private int mColumnHeaderHeight;
    private int mSelectedColor;
    private int mUnSelectedColor;
    private int mShadowColor;
    private int mSeparatorColor = -1;
    private boolean mHasFixedWidth;
    private boolean mIgnoreSelectionColors;
    private boolean mShowHorizontalSeparators = true;
    private boolean mShowVerticalSeparators = true;
    private boolean mIsSortable;

    public TableView(@NonNull Context context) {
        super(context);
        this.initialDefaultValues(null);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialDefaultValues(attrs);
        this.initialize();
    }

    public TableView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialDefaultValues(null);
        this.initialize();
    }

    private void initialDefaultValues(AttributeSet attrs) {
        this.mRowHeaderWidth = (int)this.getResources().getDimension(R.dimen.default_row_header_width);
        this.mColumnHeaderHeight = (int)this.getResources().getDimension(R.dimen.default_column_header_height);
        this.mSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_selected_background_color);
        this.mUnSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_unselected_background_color);
        this.mShadowColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_shadow_background_color);
        if (attrs == null) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.TableView, 0, 0);
        try {
            this.mRowHeaderWidth = (int)a.getDimension(R.styleable.TableView_row_header_width, (float)this.mRowHeaderWidth);
            this.mColumnHeaderHeight = (int)a.getDimension(R.styleable.TableView_column_header_height, (float)this.mColumnHeaderHeight);
            this.mSelectedColor = a.getColor(R.styleable.TableView_selected_color, this.mSelectedColor);
            this.mUnSelectedColor = a.getColor(R.styleable.TableView_unselected_color, this.mUnSelectedColor);
            this.mShadowColor = a.getColor(R.styleable.TableView_shadow_color, this.mShadowColor);
            this.mSeparatorColor = a.getColor(R.styleable.TableView_separator_color, ContextCompat.getColor((Context)this.getContext(), (int)R.color.table_view_default_separator_color));
            this.mShowVerticalSeparators = a.getBoolean(R.styleable.TableView_show_vertical_separator, this.mShowVerticalSeparators);
            this.mShowHorizontalSeparators = a.getBoolean(R.styleable.TableView_show_horizontal_separator, this.mShowHorizontalSeparators);
        }
        finally {
            a.recycle();
        }
    }

    private void initialize() {
        this.mColumnHeaderRecyclerView = this.createColumnHeaderRecyclerView();
        this.mRowHeaderRecyclerView = this.createRowHeaderRecyclerView();
        this.mCellRecyclerView = this.createCellRecyclerView();
        this.addView((View)this.mColumnHeaderRecyclerView);
        this.addView((View)this.mRowHeaderRecyclerView);
        this.addView((View)this.mCellRecyclerView);
        this.mSelectionHandler = new SelectionHandler(this);
        this.mVisibilityHandler = new VisibilityHandler(this);
        this.mScrollHandler = new ScrollHandler(this);
        this.mPreferencesHandler = new PreferencesHandler(this);
        this.initializeListeners();
    }

    protected void initializeListeners() {
        this.mVerticalRecyclerListener = new VerticalRecyclerViewListener(this);
        this.mRowHeaderRecyclerView.addOnItemTouchListener(this.mVerticalRecyclerListener);
        this.mCellRecyclerView.addOnItemTouchListener(this.mVerticalRecyclerListener);
        this.mHorizontalRecyclerViewListener = new HorizontalRecyclerViewListener(this);
        this.mColumnHeaderRecyclerView.addOnItemTouchListener(this.mHorizontalRecyclerViewListener);
        this.mColumnHeaderRecyclerViewItemClickListener = new ColumnHeaderRecyclerViewItemClickListener(this.mColumnHeaderRecyclerView, this);
        this.mRowHeaderRecyclerViewItemClickListener = new RowHeaderRecyclerViewItemClickListener(this.mRowHeaderRecyclerView, this);
        this.mColumnHeaderRecyclerView.addOnItemTouchListener(this.mColumnHeaderRecyclerViewItemClickListener);
        this.mRowHeaderRecyclerView.addOnItemTouchListener(this.mRowHeaderRecyclerViewItemClickListener);
        TableViewLayoutChangeListener layoutChangeListener = new TableViewLayoutChangeListener(this);
        this.mColumnHeaderRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
        this.mCellRecyclerView.addOnLayoutChangeListener(layoutChangeListener);
    }

    protected CellRecyclerView createColumnHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getColumnHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, this.mColumnHeaderHeight);
        layoutParams.leftMargin = this.mRowHeaderWidth;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowHorizontalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getHorizontalItemDecoration());
        }
        return recyclerView;
    }

    protected CellRecyclerView createRowHeaderRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getRowHeaderLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(this.mRowHeaderWidth, -2);
        layoutParams.topMargin = this.mColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    protected CellRecyclerView createCellRecyclerView() {
        CellRecyclerView recyclerView = new CellRecyclerView(this.getContext());
        recyclerView.setMotionEventSplittingEnabled(false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.getCellLayoutManager());
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = this.mRowHeaderWidth;
        layoutParams.topMargin = this.mColumnHeaderHeight;
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.isShowVerticalSeparators()) {
            recyclerView.addItemDecoration((RecyclerView.ItemDecoration)this.getVerticalItemDecoration());
        }
        return recyclerView;
    }

    public void setAdapter(AbstractTableAdapter tableAdapter) {
        if (tableAdapter != null) {
            this.mTableAdapter = tableAdapter;
            this.mTableAdapter.setRowHeaderWidth(this.mRowHeaderWidth);
            this.mTableAdapter.setColumnHeaderHeight(this.mColumnHeaderHeight);
            this.mTableAdapter.setTableView(this);
            if (this.mColumnHeaderRecyclerView != null) {
                this.mColumnHeaderRecyclerView.setAdapter(this.mTableAdapter.getColumnHeaderRecyclerViewAdapter());
            }
            if (this.mRowHeaderRecyclerView != null) {
                this.mRowHeaderRecyclerView.setAdapter(this.mTableAdapter.getRowHeaderRecyclerViewAdapter());
            }
            if (this.mCellRecyclerView != null) {
                this.mCellRecyclerView.setAdapter(this.mTableAdapter.getCellRecyclerViewAdapter());
                this.mColumnSortHandler = new ColumnSortHandler(this);
                this.mFilterHandler = new FilterHandler(this);
            }
        }
    }

    @Override
    public boolean hasFixedWidth() {
        return this.mHasFixedWidth;
    }

    public void setHasFixedWidth(boolean hasFixedWidth) {
        this.mHasFixedWidth = hasFixedWidth;
        this.mColumnHeaderRecyclerView.setHasFixedSize(hasFixedWidth);
    }

    @Override
    public boolean isIgnoreSelectionColors() {
        return this.mIgnoreSelectionColors;
    }

    public void setIgnoreSelectionColors(boolean ignoreSelectionColor) {
        this.mIgnoreSelectionColors = ignoreSelectionColor;
    }

    @Override
    public boolean isShowHorizontalSeparators() {
        return this.mShowHorizontalSeparators;
    }

    @Override
    public boolean isSortable() {
        return this.mIsSortable;
    }

    public void setShowHorizontalSeparators(boolean showSeparators) {
        this.mShowHorizontalSeparators = showSeparators;
    }

    @Override
    public boolean isShowVerticalSeparators() {
        return this.mShowVerticalSeparators;
    }

    public void setShowVerticalSeparators(boolean showSeparators) {
        this.mShowVerticalSeparators = showSeparators;
    }

    @Override
    public CellRecyclerView getCellRecyclerView() {
        return this.mCellRecyclerView;
    }

    @Override
    public CellRecyclerView getColumnHeaderRecyclerView() {
        return this.mColumnHeaderRecyclerView;
    }

    @Override
    public CellRecyclerView getRowHeaderRecyclerView() {
        return this.mRowHeaderRecyclerView;
    }

    @Override
    public ColumnHeaderLayoutManager getColumnHeaderLayoutManager() {
        if (this.mColumnHeaderLayoutManager == null) {
            this.mColumnHeaderLayoutManager = new ColumnHeaderLayoutManager(this.getContext(), this);
        }
        return this.mColumnHeaderLayoutManager;
    }

    @Override
    public CellLayoutManager getCellLayoutManager() {
        if (this.mCellLayoutManager == null) {
            this.mCellLayoutManager = new CellLayoutManager(this.getContext(), this);
        }
        return this.mCellLayoutManager;
    }

    @Override
    public LinearLayoutManager getRowHeaderLayoutManager() {
        if (this.mRowHeaderLayoutManager == null) {
            this.mRowHeaderLayoutManager = new LinearLayoutManager(this.getContext(), 1, false);
        }
        return this.mRowHeaderLayoutManager;
    }

    @Override
    public HorizontalRecyclerViewListener getHorizontalRecyclerViewListener() {
        return this.mHorizontalRecyclerViewListener;
    }

    @Override
    public VerticalRecyclerViewListener getVerticalRecyclerViewListener() {
        return this.mVerticalRecyclerListener;
    }

    @Override
    public ITableViewListener getTableViewListener() {
        return this.mTableViewListener;
    }

    public void setTableViewListener(ITableViewListener tableViewListener) {
        this.mTableViewListener = tableViewListener;
    }

    @Override
    public void sortColumn(int columnPosition, SortState sortState) {
        this.mIsSortable = true;
        this.mColumnSortHandler.sort(columnPosition, sortState);
    }

    @Override
    public void sortRowHeader(SortState sortState) {
        this.mIsSortable = true;
        this.mColumnSortHandler.sortByRowHeader(sortState);
    }

    @Override
    public void remeasureColumnWidth(int column) {
        this.getColumnHeaderLayoutManager().removeCachedWidth(column);
        this.getCellLayoutManager().fitWidthSize(column, false);
    }

    @Override
    public AbstractTableAdapter getAdapter() {
        return this.mTableAdapter;
    }

    @Override
    public void filter(Filter filter) {
        this.mFilterHandler.filter(filter);
    }

    @Override
    public FilterHandler getFilterHandler() {
        return this.mFilterHandler;
    }

    @Override
    public SortState getSortingStatus(int column) {
        return this.mColumnSortHandler.getSortingStatus(column);
    }

    @Override
    public SortState getRowHeaderSortingStatus() {
        return this.mColumnSortHandler.getRowHeaderSortingStatus();
    }

    @Override
    public void scrollToColumnPosition(int column) {
        this.mScrollHandler.scrollToColumnPosition(column);
    }

    @Override
    public void scrollToColumnPosition(int column, int offset) {
        this.mScrollHandler.scrollToColumnPosition(column, offset);
    }

    @Override
    public void scrollToRowPosition(int row) {
        this.mScrollHandler.scrollToRowPosition(row);
    }

    @Override
    public void scrollToRowPosition(int row, int offset) {
        this.mScrollHandler.scrollToRowPosition(row, offset);
    }

    @Override
    public ScrollHandler getScrollHandler() {
        return this.mScrollHandler;
    }

    @Override
    public void showRow(int row) {
        this.mVisibilityHandler.showRow(row);
    }

    @Override
    public void hideRow(int row) {
        this.mVisibilityHandler.hideRow(row);
    }

    @Override
    public void showAllHiddenRows() {
        this.mVisibilityHandler.showAllHiddenRows();
    }

    @Override
    public void clearHiddenRowList() {
        this.mVisibilityHandler.clearHideRowList();
    }

    @Override
    public void showColumn(int column) {
        this.mVisibilityHandler.showColumn(column);
    }

    @Override
    public void hideColumn(int column) {
        this.mVisibilityHandler.hideColumn(column);
    }

    @Override
    public boolean isColumnVisible(int column) {
        return this.mVisibilityHandler.isColumnVisible(column);
    }

    @Override
    public void showAllHiddenColumns() {
        this.mVisibilityHandler.showAllHiddenColumns();
    }

    @Override
    public void clearHiddenColumnList() {
        this.mVisibilityHandler.clearHideColumnList();
    }

    @Override
    public boolean isRowVisible(int row) {
        return this.mVisibilityHandler.isRowVisible(row);
    }

    public int getSelectedRow() {
        return this.mSelectionHandler.getSelectedRowPosition();
    }

    public void setSelectedRow(int row) {
        AbstractViewHolder rowViewHolder = (AbstractViewHolder)this.getRowHeaderRecyclerView().findViewHolderForAdapterPosition(row);
        this.mSelectionHandler.setSelectedRowPosition(rowViewHolder, row);
    }

    public int getSelectedColumn() {
        return this.mSelectionHandler.getSelectedColumnPosition();
    }

    public void setSelectedColumn(int column) {
        AbstractViewHolder columnViewHolder = (AbstractViewHolder)this.getColumnHeaderRecyclerView().findViewHolderForAdapterPosition(column);
        this.mSelectionHandler.setSelectedColumnPosition(columnViewHolder, column);
    }

    public void setSelectedCell(int column, int row) {
        AbstractViewHolder cellViewHolder = this.getCellLayoutManager().getCellViewHolder(column, row);
        this.mSelectionHandler.setSelectedCellPositions(cellViewHolder, column, row);
    }

    @Override
    public SelectionHandler getSelectionHandler() {
        return this.mSelectionHandler;
    }

    @Override
    public ColumnSortHandler getColumnSortHandler() {
        return this.mColumnSortHandler;
    }

    @Override
    public DividerItemDecoration getHorizontalItemDecoration() {
        if (this.mHorizontalItemDecoration == null) {
            this.mHorizontalItemDecoration = this.createItemDecoration(0);
        }
        return this.mHorizontalItemDecoration;
    }

    @Override
    public DividerItemDecoration getVerticalItemDecoration() {
        if (this.mVerticalItemDecoration == null) {
            this.mVerticalItemDecoration = this.createItemDecoration(1);
        }
        return this.mVerticalItemDecoration;
    }

    protected DividerItemDecoration createItemDecoration(int orientation) {
        Drawable divider = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.cell_line_divider);
        if (this.mSeparatorColor != -1) {
            divider.setColorFilter(this.mSeparatorColor, PorterDuff.Mode.SRC_ATOP);
        }
        DividerItemDecoration itemDecoration = new DividerItemDecoration(this.getContext(), orientation);
        itemDecoration.setDrawable(divider);
        return itemDecoration;
    }

    public void setSelectedColor(@ColorInt int selectedColor) {
        this.mSelectedColor = selectedColor;
    }

    @Override
    @ColorInt
    public int getSelectedColor() {
        return this.mSelectedColor;
    }

    public void setUnSelectedColor(@ColorInt int unSelectedColor) {
        this.mUnSelectedColor = unSelectedColor;
    }

    @Override
    @ColorInt
    public int getUnSelectedColor() {
        return this.mUnSelectedColor;
    }

    public void setShadowColor(@ColorInt int shadowColor) {
        this.mShadowColor = shadowColor;
    }

    @Override
    @ColorInt
    public int getShadowColor() {
        return this.mShadowColor;
    }

    @Override
    public int getRowHeaderWidth() {
        return this.mRowHeaderWidth;
    }

    @Override
    public void setRowHeaderWidth(int rowHeaderWidth) {
        ViewGroup.LayoutParams layoutParams;
        this.mRowHeaderWidth = rowHeaderWidth;
        if (this.mRowHeaderRecyclerView != null) {
            layoutParams = this.mRowHeaderRecyclerView.getLayoutParams();
            layoutParams.width = rowHeaderWidth;
            this.mRowHeaderRecyclerView.setLayoutParams(layoutParams);
            this.mRowHeaderRecyclerView.requestLayout();
        }
        if (this.mColumnHeaderRecyclerView != null) {
            layoutParams = (FrameLayout.LayoutParams)this.mColumnHeaderRecyclerView.getLayoutParams();
            layoutParams.leftMargin = rowHeaderWidth;
            this.mColumnHeaderRecyclerView.setLayoutParams(layoutParams);
            this.mColumnHeaderRecyclerView.requestLayout();
        }
        if (this.mCellRecyclerView != null) {
            layoutParams = (FrameLayout.LayoutParams)this.mCellRecyclerView.getLayoutParams();
            layoutParams.leftMargin = rowHeaderWidth;
            this.mCellRecyclerView.setLayoutParams(layoutParams);
            this.mCellRecyclerView.requestLayout();
        }
        if (this.getAdapter() != null) {
            this.getAdapter().setRowHeaderWidth(rowHeaderWidth);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState state = new SavedState(super.onSaveInstanceState());
        state.preferences = this.mPreferencesHandler.savePreferences();
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mPreferencesHandler.loadPreferences(savedState.preferences);
    }
}

