/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.handler;

import android.support.v7.util.DiffUtil;
import android.support.v7.widget.RecyclerView;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.ColumnHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.adapter.recyclerview.RowHeaderRecyclerViewAdapter;
import com.evrencoskun.tableview.sort.ColumnForRowHeaderSortComparator;
import com.evrencoskun.tableview.sort.ColumnSortCallback;
import com.evrencoskun.tableview.sort.ColumnSortComparator;
import com.evrencoskun.tableview.sort.ISortableModel;
import com.evrencoskun.tableview.sort.RowHeaderForCellSortComparator;
import com.evrencoskun.tableview.sort.RowHeaderSortCallback;
import com.evrencoskun.tableview.sort.RowHeaderSortComparator;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ColumnSortHandler {
    private CellRecyclerViewAdapter mCellRecyclerViewAdapter;
    private RowHeaderRecyclerViewAdapter mRowHeaderRecyclerViewAdapter;
    private ColumnHeaderRecyclerViewAdapter mColumnHeaderRecyclerViewAdapter;
    private boolean mEnableAnimation = true;

    public boolean isEnableAnimation() {
        return this.mEnableAnimation;
    }

    public void setEnableAnimation(boolean mEnableAnimation) {
        this.mEnableAnimation = mEnableAnimation;
    }

    public ColumnSortHandler(ITableView tableView) {
        this.mCellRecyclerViewAdapter = (CellRecyclerViewAdapter)tableView.getCellRecyclerView().getAdapter();
        this.mRowHeaderRecyclerViewAdapter = (RowHeaderRecyclerViewAdapter)tableView.getRowHeaderRecyclerView().getAdapter();
        this.mColumnHeaderRecyclerViewAdapter = (ColumnHeaderRecyclerViewAdapter)tableView.getColumnHeaderRecyclerView().getAdapter();
    }

    public void sortByRowHeader(SortState sortState) {
        List<ISortableModel> originalRowHeaderList = this.mRowHeaderRecyclerViewAdapter.getItems();
        ArrayList<ISortableModel> sortedRowHeaderList = new ArrayList<ISortableModel>(originalRowHeaderList);
        List<List<ISortableModel>> originalList = this.mCellRecyclerViewAdapter.getItems();
        ArrayList<List<ISortableModel>> sortedList = new ArrayList<List<ISortableModel>>(originalList);
        if (sortState != SortState.UNSORTED) {
            Collections.sort(sortedRowHeaderList, new RowHeaderSortComparator(sortState));
            RowHeaderForCellSortComparator rowHeaderForCellSortComparator = new RowHeaderForCellSortComparator(originalRowHeaderList, originalList, sortState);
            Collections.sort(sortedList, rowHeaderForCellSortComparator);
        }
        this.mRowHeaderRecyclerViewAdapter.getRowHeaderSortHelper().setSortingStatus(sortState);
        this.swapItems(originalRowHeaderList, sortedRowHeaderList, sortedList);
    }

    public void sort(int column, SortState sortState) {
        List<List<ISortableModel>> originalList = this.mCellRecyclerViewAdapter.getItems();
        ArrayList<List<ISortableModel>> sortedList = new ArrayList<List<ISortableModel>>(originalList);
        List<ISortableModel> originalRowHeaderList = this.mRowHeaderRecyclerViewAdapter.getItems();
        ArrayList<ISortableModel> sortedRowHeaderList = new ArrayList<ISortableModel>(originalRowHeaderList);
        if (sortState != SortState.UNSORTED) {
            Collections.sort(sortedList, new ColumnSortComparator(column, sortState));
            ColumnForRowHeaderSortComparator columnForRowHeaderSortComparator = new ColumnForRowHeaderSortComparator(originalRowHeaderList, originalList, column, sortState);
            Collections.sort(sortedRowHeaderList, columnForRowHeaderSortComparator);
        }
        this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().setSortingStatus(column, sortState);
        this.swapItems(originalList, sortedList, column, sortedRowHeaderList);
    }

    private void swapItems(List<ISortableModel> oldRowHeader, List<ISortableModel> newRowHeader, List<List<ISortableModel>> newColumnItems) {
        this.mRowHeaderRecyclerViewAdapter.setItems(newRowHeader, !this.mEnableAnimation);
        this.mCellRecyclerViewAdapter.setItems(newColumnItems, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            RowHeaderSortCallback diffCallback = new RowHeaderSortCallback(oldRowHeader, newRowHeader);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mRowHeaderRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mCellRecyclerViewAdapter);
        }
    }

    private void swapItems(List<List<ISortableModel>> oldItems, List<List<ISortableModel>> newItems, int column, List<ISortableModel> newRowHeader) {
        this.mCellRecyclerViewAdapter.setItems(newItems, !this.mEnableAnimation);
        this.mRowHeaderRecyclerViewAdapter.setItems(newRowHeader, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            ColumnSortCallback diffCallback = new ColumnSortCallback(oldItems, newItems, column);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mCellRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mRowHeaderRecyclerViewAdapter);
        }
    }

    public void swapItems(List<List<ISortableModel>> newItems, int column) {
        List<List<ISortableModel>> oldItems = this.mCellRecyclerViewAdapter.getItems();
        this.mCellRecyclerViewAdapter.setItems(newItems, !this.mEnableAnimation);
        if (this.mEnableAnimation) {
            ColumnSortCallback diffCallback = new ColumnSortCallback(oldItems, newItems, column);
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)diffCallback);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mCellRecyclerViewAdapter);
            diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this.mRowHeaderRecyclerViewAdapter);
        }
    }

    public SortState getSortingStatus(int column) {
        return this.mColumnHeaderRecyclerViewAdapter.getColumnSortHelper().getSortingStatus(column);
    }

    public SortState getRowHeaderSortingStatus() {
        return this.mRowHeaderRecyclerViewAdapter.getRowHeaderSortHelper().getSortingStatus();
    }
}

