/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import android.util.Log;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractSorterViewHolder;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.layoutmanager.ColumnHeaderLayoutManager;
import com.evrencoskun.tableview.sort.SortState;
import java.util.ArrayList;
import java.util.List;

public class ColumnSortHelper {
    private List<Directive> sortingColumns = new ArrayList<Directive>();
    private ColumnHeaderLayoutManager mColumnHeaderLayoutManager;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, SortState.UNSORTED);

    public ColumnSortHelper(ColumnHeaderLayoutManager pColumnHeaderLayoutManager) {
        this.mColumnHeaderLayoutManager = pColumnHeaderLayoutManager;
    }

    private void sortingStatusChanged(int pColumn, SortState status) {
        AbstractViewHolder holder = this.mColumnHeaderLayoutManager.getViewHolder(pColumn);
        if (holder != null) {
            if (holder instanceof AbstractSorterViewHolder) {
                ((AbstractSorterViewHolder)holder).onSortingStatusChanged(status);
            } else {
                Log.e((String)ColumnSortHelper.class.getSimpleName(), (String)"For sorting process, column header view holders must be extended from AbstractSorterViewHolder class");
            }
        }
    }

    public void setSortingStatus(int column, SortState status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != SortState.UNSORTED) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged(column, status);
    }

    public void clearSortingStatus() {
        this.sortingColumns.clear();
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    public SortState getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public class TableViewSorterException
    extends Exception {
        public TableViewSorterException() {
            super("For sorting process, column header view holders must be extended from AbstractSorterViewHolder class");
        }
    }

    private static class Directive {
        private int column;
        private SortState direction;

        public Directive(int column, SortState direction) {
            this.column = column;
            this.direction = direction;
        }
    }
}

