/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.sort;

import android.support.v7.util.DiffUtil;
import com.evrencoskun.tableview.sort.ISortableModel;
import java.util.List;

public class ColumnSortCallback
extends DiffUtil.Callback {
    private static final String LOG_TAG = ColumnSortCallback.class.getSimpleName();
    private List<List<ISortableModel>> m_jOldCellItems;
    private List<List<ISortableModel>> m_jNewCellItems;
    private int m_nColumnPosition;

    public ColumnSortCallback(List<List<ISortableModel>> p_jOldCellItems, List<List<ISortableModel>> p_jNewCellItems, int p_nColumnPosition) {
        this.m_jOldCellItems = p_jOldCellItems;
        this.m_jNewCellItems = p_jNewCellItems;
        this.m_nColumnPosition = p_nColumnPosition;
    }

    public int getOldListSize() {
        return this.m_jOldCellItems.size();
    }

    public int getNewListSize() {
        return this.m_jNewCellItems.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.m_jOldCellItems.size() > oldItemPosition && this.m_jNewCellItems.size() > newItemPosition && this.m_jOldCellItems.get(oldItemPosition).size() > this.m_nColumnPosition && this.m_jNewCellItems.get(newItemPosition).size() > this.m_nColumnPosition) {
            String oldId = this.m_jOldCellItems.get(oldItemPosition).get(this.m_nColumnPosition).getId();
            String newId = this.m_jNewCellItems.get(newItemPosition).get(this.m_nColumnPosition).getId();
            return oldId.equals(newId);
        }
        return false;
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        if (this.m_jOldCellItems.size() > oldItemPosition && this.m_jNewCellItems.size() > newItemPosition && this.m_jOldCellItems.get(oldItemPosition).size() > this.m_nColumnPosition && this.m_jNewCellItems.get(newItemPosition).size() > this.m_nColumnPosition) {
            Object oldContent = this.m_jOldCellItems.get(oldItemPosition).get(this.m_nColumnPosition).getContent();
            Object newContent = this.m_jNewCellItems.get(newItemPosition).get(this.m_nColumnPosition).getContent();
            return oldContent.equals(newContent);
        }
        return false;
    }
}

