/*
 * Decompiled with CFR 0.152.
 */
package com.evrencoskun.tableview.listener.itemclick;

import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import com.evrencoskun.tableview.ITableView;
import com.evrencoskun.tableview.adapter.recyclerview.CellRecyclerView;
import com.evrencoskun.tableview.adapter.recyclerview.holder.AbstractViewHolder;
import com.evrencoskun.tableview.listener.itemclick.AbstractItemClickListener;

public class RowHeaderRecyclerViewItemClickListener
extends AbstractItemClickListener {
    public RowHeaderRecyclerViewItemClickListener(CellRecyclerView p_jRecyclerView, ITableView p_iTableView) {
        super(p_jRecyclerView, p_iTableView);
    }

    @Override
    protected boolean clickAction(RecyclerView view, MotionEvent e) {
        View childView = view.findChildViewUnder(e.getX(), e.getY());
        if (childView != null && this.m_jGestureDetector.onTouchEvent(e)) {
            AbstractViewHolder holder = (AbstractViewHolder)this.m_jRecyclerView.getChildViewHolder(childView);
            int nYPosition = holder.getAdapterPosition();
            if (!this.m_iTableView.isIgnoreSelectionColors()) {
                this.m_iSelectionHandler.setSelectedRowPosition(holder, nYPosition);
            }
            if (this.getTableViewListener() != null) {
                this.getTableViewListener().onRowHeaderClicked(holder, nYPosition);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void longPressAction(MotionEvent e) {
        if (this.m_jRecyclerView.getScrollState() != 0) {
            return;
        }
        View child = this.m_jRecyclerView.findChildViewUnder(e.getX(), e.getY());
        if (child != null && this.getTableViewListener() != null) {
            RecyclerView.ViewHolder holder = this.m_jRecyclerView.getChildViewHolder(child);
            this.getTableViewListener().onRowHeaderLongPressed(holder, holder.getAdapterPosition());
        }
    }
}

